/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.openecard.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.openecard.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.openecard.bouncycastle.crypto.KeyGenerationParameters;
import org.openecard.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import org.openecard.bouncycastle.crypto.params.DHParameters;
import org.openecard.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import org.openecard.bouncycastle.crypto.params.ElGamalParameters;
import org.openecard.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters egp = this.param.getParameters();
        DHParameters dhp = new DHParameters(egp.getP(), egp.getG(), null, egp.getL());
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, egp), new ElGamalPrivateKeyParameters(x, egp));
    }
}

