/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.recognition;

import iso.std.iso_iec._24727.tech.schema.CardCall;
import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.Connect;
import iso.std.iso_iec._24727.tech.schema.ConnectResponse;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DataMaskType;
import iso.std.iso_iec._24727.tech.schema.Disconnect;
import iso.std.iso_iec._24727.tech.schema.DisconnectResponse;
import iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACDResponse;
import iso.std.iso_iec._24727.tech.schema.GetRecognitionTreeResponse;
import iso.std.iso_iec._24727.tech.schema.InputAPDUInfoType;
import iso.std.iso_iec._24727.tech.schema.MatchingDataType;
import iso.std.iso_iec._24727.tech.schema.RecognitionTree;
import iso.std.iso_iec._24727.tech.schema.ResponseAPDUType;
import iso.std.iso_iec._24727.tech.schema.Transmit;
import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeMap;
import oasis.names.tc.dss._1_0.core.schema.InternationalStringType;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.FileUtils;
import org.openecard.recognition.RecognitionException;
import org.openecard.recognition.RecognitionProperties;
import org.openecard.recognition.staticrepo.LocalCifRepo;
import org.openecard.recognition.statictree.LocalFileTree;
import org.openecard.ws.GetCardInfoOrACD;
import org.openecard.ws.GetRecognitionTree;
import org.openecard.ws.IFD;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardRecognition {
    private static final Logger _logger = LoggerFactory.getLogger(CardRecognition.class);
    private final RecognitionTree tree;
    private final GetCardInfoOrACD cifRepo;
    private final TreeMap<String, CardInfoType> cifCache = new TreeMap();
    private final Properties cardImagesMap = new Properties();
    private final IFD ifd;
    private final byte[] ctx;

    public CardRecognition(IFD ifd, byte[] ctx) throws Exception {
        this(ifd, ctx, null, null);
    }

    public CardRecognition(IFD ifd, byte[] ctx, GetRecognitionTree treeRepo, GetCardInfoOrACD cifRepo) throws Exception {
        this.ifd = ifd;
        this.ctx = ByteUtils.clone(ctx);
        WSMarshaller marshaller = WSMarshallerFactory.createInstance();
        if (treeRepo == null) {
            treeRepo = new LocalFileTree(marshaller);
        }
        if (cifRepo == null) {
            cifRepo = new LocalCifRepo(marshaller);
        }
        this.cifRepo = cifRepo;
        this.cardImagesMap.load(FileUtils.resolveResourceAsStream(CardRecognition.class, "/card-images/card-images.properties"));
        iso.std.iso_iec._24727.tech.schema.GetRecognitionTree req = new iso.std.iso_iec._24727.tech.schema.GetRecognitionTree();
        req.setAction(RecognitionProperties.getAction());
        GetRecognitionTreeResponse resp = treeRepo.getRecognitionTree(req);
        this.checkResult(resp.getResult());
        this.tree = resp.getRecognitionTree();
    }

    public List<CardInfoType> getCardInfos() {
        iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACD req = new iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACD();
        req.setAction("http://www.bsi.bund.de/ecard/api/1.1/cardinfo/action#getOtherFiles");
        GetCardInfoOrACDResponse res = this.cifRepo.getCardInfoOrACD(req);
        List<Object> cifs = res.getCardInfoOrCapabilityInfo();
        ArrayList<CardInfoType> result = new ArrayList<CardInfoType>();
        for (Object next : cifs) {
            if (!(next instanceof CardInfoType)) continue;
            result.add((CardInfoType)next);
        }
        return result;
    }

    public CardInfoType getCardInfo(String type) {
        if (this.cifRepo != null) {
            if (this.cifCache.containsKey(type)) {
                return this.cifCache.get(type);
            }
            iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACD req = new iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACD();
            req.setAction("http://www.bsi.bund.de/ecard/api/1.1/cardinfo/action#getSpecifiedFile");
            req.getCardTypeIdentifier().add(type);
            GetCardInfoOrACDResponse res = this.cifRepo.getCardInfoOrACD(req);
            List<Object> cifs = res.getCardInfoOrCapabilityInfo();
            for (Object next : cifs) {
                if (!(next instanceof CardInfoType)) continue;
                this.cifCache.put(type, (CardInfoType)next);
                return (CardInfoType)next;
            }
            this.cifCache.put(type, null);
            return null;
        }
        return null;
    }

    public String getTranslatedCardName(String cardType) {
        CardInfoType info = this.getCardInfo(cardType);
        Locale userLocale = Locale.getDefault();
        String langCode = userLocale.getLanguage();
        String enFallback = "Unknown card type.";
        for (InternationalStringType typ : info.getCardType().getCardTypeName()) {
            if (typ.getLang().equalsIgnoreCase("en")) {
                enFallback = typ.getValue();
            }
            if (!typ.getLang().equalsIgnoreCase(langCode)) continue;
            return typ.getValue();
        }
        return enFallback;
    }

    public InputStream getCardImage(String objectid) {
        String fname = this.cardImagesMap.getProperty(objectid);
        InputStream fs = null;
        if (fname != null) {
            fs = CardRecognition.loadCardImage(fname);
        }
        if (fs == null) {
            fs = this.getUnknownCardImage();
        }
        return fs;
    }

    public InputStream getUnknownCardImage() {
        return CardRecognition.loadCardImage("unknown_card.png");
    }

    public InputStream getNoCardImage() {
        return CardRecognition.loadCardImage("no_card.png");
    }

    public InputStream getNoTerminalImage() {
        return CardRecognition.loadCardImage("no_terminal.png");
    }

    private static InputStream loadCardImage(String filename) {
        try {
            return FileUtils.resolveResourceAsStream(CardRecognition.class, "/card-images/" + filename);
        }
        catch (IOException ex) {
            _logger.info("Failed to load card image '" + filename + "'.", ex);
            return null;
        }
    }

    public ConnectionHandleType.RecognitionInfo recognizeCard(String ifdName, BigInteger slot) throws RecognitionException {
        byte[] slotHandle = this.connect(ifdName, slot);
        String type = this.treeCalls(slotHandle, this.tree.getCardCall());
        this.disconnect(slotHandle);
        if (type == null) {
            return null;
        }
        ConnectionHandleType.RecognitionInfo info = new ConnectionHandleType.RecognitionInfo();
        info.setCardType(type);
        return info;
    }

    private void checkResult(Result r) throws RecognitionException {
        if (r.getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
            throw new RecognitionException(r);
        }
    }

    private boolean checkTransmitResult(TransmitResponse r) {
        return !r.getOutputAPDU().isEmpty() && r.getOutputAPDU().get(0).length >= 2;
    }

    private byte[] connect(String ifdName, BigInteger slot) throws RecognitionException {
        Connect c = new Connect();
        c.setContextHandle(this.ctx);
        c.setIFDName(ifdName);
        c.setSlot(slot);
        ConnectResponse r = this.ifd.connect(c);
        this.checkResult(r.getResult());
        return r.getSlotHandle();
    }

    private void disconnect(byte[] slotHandle) throws RecognitionException {
        Disconnect c = new Disconnect();
        c.setSlotHandle(slotHandle);
        DisconnectResponse r = this.ifd.disconnect(c);
        this.checkResult(r.getResult());
    }

    private byte[] transmit(byte[] slotHandle, byte[] input, List<ResponseAPDUType> results) {
        Transmit t = new Transmit();
        t.setSlotHandle(slotHandle);
        InputAPDUInfoType apdu = new InputAPDUInfoType();
        apdu.setInputAPDU(input);
        for (ResponseAPDUType result : results) {
            apdu.getAcceptableStatusCode().add(result.getTrailer());
        }
        t.getInputAPDUInfo().add(apdu);
        TransmitResponse r = this.ifd.transmit(t);
        if (this.checkTransmitResult(r)) {
            return r.getOutputAPDU().get(0);
        }
        return null;
    }

    private List<CardCall> branch2list(CardCall first) {
        LinkedList<CardCall> calls = new LinkedList<CardCall>();
        calls.add(first);
        CardCall next = first;
        while (next.getResponseAPDU().get(0).getBody() == null) {
            next = next.getResponseAPDU().get(0).getConclusion().getCardCall().get(0);
            calls.add(next);
        }
        return calls;
    }

    private String treeCalls(byte[] slotHandle, List<CardCall> calls) throws RecognitionException {
        block0: for (CardCall c : calls) {
            List<CardCall> branch = this.branch2list(c);
            for (CardCall next : branch) {
                boolean matcher = next.getResponseAPDU().get(0).getBody() != null;
                byte[] resultBytes = this.transmit(slotHandle, next.getCommandAPDU(), next.getResponseAPDU());
                if (resultBytes == null) continue block0;
                byte[] result = CardResponseAPDU.getData(resultBytes);
                byte[] trailer = CardResponseAPDU.getTrailer(resultBytes);
                if (!matcher && !Arrays.equals(next.getResponseAPDU().get(0).getTrailer(), trailer)) continue block0;
                if (!matcher) continue;
                for (ResponseAPDUType r : next.getResponseAPDU()) {
                    if (!Arrays.equals(r.getTrailer(), trailer) || !this.checkDataObject(r.getBody(), result)) continue;
                    if (r.getConclusion().getRecognizedCardType() != null) {
                        return r.getConclusion().getRecognizedCardType();
                    }
                    return this.treeCalls(slotHandle, r.getConclusion().getCardCall());
                }
            }
        }
        return null;
    }

    private boolean checkDataObject(DataMaskType matcher, byte[] result) {
        if (matcher.getTag() != null && matcher.getDataObject() != null) {
            try {
                TLV tlv = TLV.fromBER(result);
                return this.checkDataObject(matcher, tlv);
            }
            catch (TLVException tLVException) {
                return false;
            }
        }
        return this.checkMatchingData(matcher.getMatchingData(), result);
    }

    private boolean checkDataObject(DataMaskType matcher, TLV result) {
        byte[] tag = matcher.getTag();
        DataMaskType nextMatcher = matcher.getDataObject();
        if (tag == null || nextMatcher == null) {
            return false;
        }
        long tagNum = ByteUtils.toLong(tag);
        List<TLV> chunks = result.findNextTags(tagNum);
        for (TLV next : chunks) {
            boolean outcome = nextMatcher.getMatchingData() != null ? this.checkMatchingData(nextMatcher.getMatchingData(), next.getValue()) : this.checkDataObject(nextMatcher, next.getChild());
            if (!outcome) continue;
            return true;
        }
        return false;
    }

    private boolean checkMatchingData(MatchingDataType matcher, byte[] result) {
        int i;
        byte[] offsetBytes = matcher.getOffset();
        byte[] lengthBytes = matcher.getLength();
        byte[] valueBytes = matcher.getMatchingValue();
        byte[] maskBytes = matcher.getMask();
        if (offsetBytes == null) {
            offsetBytes = new byte[]{0, 0};
        }
        int offset = ByteUtils.toInteger(offsetBytes);
        int length = ByteUtils.toInteger(lengthBytes);
        if (maskBytes == null) {
            maskBytes = new byte[valueBytes.length];
            for (i = 0; i < maskBytes.length; ++i) {
                maskBytes[i] = -1;
            }
        }
        if (maskBytes.length != valueBytes.length) {
            return false;
        }
        if (valueBytes.length != length) {
            return false;
        }
        if (result.length < length + offset) {
            return false;
        }
        for (i = offset; i < length + offset; ++i) {
            if ((maskBytes[i - offset] & result[i]) == valueBytes[i - offset]) continue;
            return false;
        }
        return true;
    }
}

