/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.reader;

import java.util.Arrays;

public class EstablishPACEResponse {
    private byte[] statusBytes;
    private short efCardAccessLength;
    private byte[] efCardAccess;
    private byte currentCARLength;
    private byte[] currentCAR;
    private byte previousCARLength;
    private byte[] previousCAR;
    private short idiccLength;
    private byte[] idicc;

    public EstablishPACEResponse(byte[] response) {
        int dataLen = response.length;
        int idx = 4;
        this.statusBytes = new byte[]{response[0], response[1]};
        this.efCardAccessLength = (short)((response[2] & 0xFF) + ((response[3] & 0xFF) << 8));
        if (this.efCardAccessLength > 0) {
            this.efCardAccess = Arrays.copyOfRange(response, idx, idx + this.efCardAccessLength);
            idx += this.efCardAccessLength;
        } else {
            this.efCardAccess = new byte[0];
        }
        if (dataLen > idx + 1) {
            this.currentCARLength = (byte)(response[idx] & 0xFF);
            ++idx;
            if (this.currentCARLength > 0) {
                this.currentCAR = Arrays.copyOfRange(response, idx, idx + this.currentCARLength);
                idx += this.currentCARLength;
            }
        }
        if (dataLen > idx + 1) {
            this.previousCARLength = (byte)(response[idx] & 0xFF);
            ++idx;
            if (this.previousCARLength > 0) {
                this.previousCAR = Arrays.copyOfRange(response, idx, idx + this.previousCARLength);
                idx += this.previousCARLength;
            }
        }
        if (dataLen > idx + 2) {
            this.idiccLength = (short)((response[idx] & 0xFF) + ((response[idx + 1] & 0xFF) << 8));
            idx += 2;
            if (this.idiccLength > 0) {
                this.idicc = Arrays.copyOfRange(response, idx, idx + this.idiccLength);
                idx += this.idiccLength;
            }
        }
    }

    public byte[] getStatus() {
        return this.statusBytes;
    }

    public byte getRetryCounter() {
        if (this.statusBytes[0] == 99 && (this.statusBytes[1] & 0xF0) == 192) {
            return (byte)(this.statusBytes[1] & 0xF);
        }
        return 3;
    }

    public boolean hasEFCardAccess() {
        return this.efCardAccessLength > 0;
    }

    public byte[] getEFCardAccess() {
        return this.efCardAccess;
    }

    public boolean hasCurrentCAR() {
        return this.currentCARLength > 0;
    }

    public byte[] getCurrentCAR() {
        return this.currentCAR;
    }

    public boolean hasPreviousCAR() {
        return this.previousCARLength > 0;
    }

    public byte[] getPreviousCAR() {
        return this.previousCAR;
    }

    public boolean hasIDICC() {
        return this.idiccLength > 0;
    }

    public byte[] getIDICC() {
        return this.idicc;
    }
}

