/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Promise<T> {
    private final CountDownLatch gate = new CountDownLatch(1);
    private boolean isSet = false;
    private T value;

    public synchronized boolean isDelivered() {
        return this.isSet;
    }

    @Nullable
    public synchronized T deliver(@Nullable T value) throws IllegalStateException {
        if (!this.isSet) {
            this.value = value;
            this.isSet = true;
            this.gate.countDown();
            return this.value;
        }
        throw new IllegalStateException("Failed to deliver promise, as it is already delivered.");
    }

    @Nullable
    public T deref() throws InterruptedException {
        try {
            return this.deref(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (TimeoutException ex) {
            return null;
        }
    }

    @Nullable
    public T deref(@Nonnegative long timeout, @Nonnull TimeUnit unit) throws InterruptedException, TimeoutException {
        boolean delivered = this.gate.await(timeout, unit);
        Promise promise = this;
        synchronized (promise) {
            if (delivered) {
                return this.value;
            }
            throw new TimeoutException("Wait for promised value timed out.");
        }
    }

    @Nullable
    public T derefNonblocking() {
        if (this.isDelivered()) {
            return this.value;
        }
        return null;
    }
}

