/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.nio.charset.Charset;
import java.util.List;
import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.TLVBitString;
import org.openecard.common.tlv.iso7816.TLVList;
import org.openecard.common.tlv.iso7816.TLVType;
import org.openecard.common.util.ByteUtils;

public class CommonObjectAttributes
extends TLVType {
    private String label;
    private TLVBitString flags;
    private byte[] authId;
    private Integer userConsent;
    private List<TLV> acls;

    public CommonObjectAttributes(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv.getChild());
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 12L))) {
            this.label = new String(p.next(0).getValue(), Charset.forName("UTF-8"));
        }
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 3L))) {
            this.flags = new TLVBitString(p.next(0), new Tag(TagClass.UNIVERSAL, true, 3L).getTagNumWithClass());
        }
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 4L))) {
            this.authId = p.next(0).getValue();
        }
        if (p.match(Tag.INTEGER_TAG)) {
            this.userConsent = ByteUtils.toInteger(p.next(0).getValue());
        }
        if (p.match(Tag.SEQUENCE_TAG)) {
            TLVList list = new TLVList(p.next(0));
            this.acls = list.getContent();
        }
    }
}

