/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.scio.osx;

import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AccessController;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.openecard.scio.osx.CardImpl;
import org.openecard.scio.osx.PCSC;
import org.openecard.scio.osx.PCSCException;
import sun.security.action.GetPropertyAction;

final class ChannelImpl
extends CardChannel {
    private final CardImpl card;
    private final int channel;
    private volatile boolean isClosed;
    private static final boolean t0GetResponse = ChannelImpl.getBooleanProperty("sun.security.smartcardio.t0GetResponse", true);
    private static final boolean t1GetResponse = ChannelImpl.getBooleanProperty("sun.security.smartcardio.t1GetResponse", true);
    private static final boolean t1StripLe = ChannelImpl.getBooleanProperty("sun.security.smartcardio.t1StripLe", false);
    private static final byte[] B0 = new byte[0];

    ChannelImpl(CardImpl card, int channel) {
        this.card = card;
        this.channel = channel;
    }

    void checkClosed() {
        this.card.checkState();
        if (this.isClosed) {
            throw new IllegalStateException("Logical channel has been closed");
        }
    }

    @Override
    public Card getCard() {
        return this.card;
    }

    @Override
    public int getChannelNumber() {
        this.checkClosed();
        return this.channel;
    }

    private static void checkManageChannel(byte[] b) {
        if (b.length < 4) {
            throw new IllegalArgumentException("Command APDU must be at least 4 bytes long");
        }
        if (b[0] >= 0 && b[1] == 112) {
            throw new IllegalArgumentException("Manage channel command not allowed, use openLogicalChannel()");
        }
    }

    @Override
    public ResponseAPDU transmit(CommandAPDU command) throws CardException {
        this.checkClosed();
        this.card.checkExclusive();
        byte[] commandBytes = command.getBytes();
        byte[] responseBytes = this.doTransmit(commandBytes);
        return new ResponseAPDU(responseBytes);
    }

    @Override
    public int transmit(ByteBuffer command, ByteBuffer response) throws CardException {
        this.checkClosed();
        this.card.checkExclusive();
        if (command == null || response == null) {
            throw new NullPointerException();
        }
        if (response.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (command == response) {
            throw new IllegalArgumentException("command and response must not be the same object");
        }
        if (response.remaining() < 258) {
            throw new IllegalArgumentException("Insufficient space in response buffer");
        }
        byte[] commandBytes = new byte[command.remaining()];
        command.get(commandBytes);
        byte[] responseBytes = this.doTransmit(commandBytes);
        response.put(responseBytes);
        return responseBytes.length;
    }

    private static boolean getBooleanProperty(String name, boolean def) {
        String val = AccessController.doPrivileged(new GetPropertyAction(name));
        if (val == null) {
            return def;
        }
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException(name + " must be either 'true' or 'false'");
    }

    private byte[] concat(byte[] b1, byte[] b2, int n2) {
        int n1 = b1.length;
        if (n1 == 0 && n2 == b2.length) {
            return b2;
        }
        byte[] res = new byte[n1 + n2];
        System.arraycopy(b1, 0, res, 0, n1);
        System.arraycopy(b2, 0, res, n1, n2);
        return res;
    }

    private byte[] doTransmit(byte[] command) throws CardException {
        try {
            int rn;
            byte[] response;
            boolean t1;
            ChannelImpl.checkManageChannel(command);
            this.setChannel(command);
            int n = command.length;
            boolean t0 = this.card.protocol == 1;
            boolean bl = t1 = this.card.protocol == 2;
            if (t0 && n >= 7 && command[4] == 0) {
                throw new CardException("Extended length forms not supported for T=0");
            }
            if ((t0 || t1 && t1StripLe) && n >= 7) {
                int lc = command[4] & 0xFF;
                if (lc != 0) {
                    if (n == lc + 6) {
                        --n;
                    }
                } else {
                    lc = (command[5] & 0xFF) << 8 | command[6] & 0xFF;
                    if (n == lc + 9) {
                        n -= 2;
                    }
                }
            }
            boolean getresponse = t0 && t0GetResponse || t1 && t1GetResponse;
            int k = 0;
            byte[] result = B0;
            while (true) {
                if (++k >= 32) {
                    throw new CardException("Could not obtain response");
                }
                response = PCSC.SCardTransmit(this.card.cardId, this.card.protocol, command, 0, n);
                rn = response.length;
                if (!getresponse || rn < 2) break;
                if (rn == 2 && response[0] == 108) {
                    command[n - 1] = response[1];
                    continue;
                }
                if (response[rn - 2] != 97) break;
                if (rn > 2) {
                    result = this.concat(result, response, rn - 2);
                }
                command[1] = -64;
                command[2] = 0;
                command[3] = 0;
                command[4] = response[rn - 1];
                n = 5;
            }
            result = this.concat(result, response, rn);
            return result;
        }
        catch (PCSCException e) {
            this.card.handleError(e);
            throw new CardException(e);
        }
    }

    private static int getSW(byte[] res) throws CardException {
        if (res.length < 2) {
            throw new CardException("Invalid response length: " + res.length);
        }
        int sw1 = res[res.length - 2] & 0xFF;
        int sw2 = res[res.length - 1] & 0xFF;
        return sw1 << 8 | sw2;
    }

    private static boolean isOK(byte[] res) throws CardException {
        return res.length == 2 && ChannelImpl.getSW(res) == 36864;
    }

    private void setChannel(byte[] com) {
        byte cla = com[0];
        if (cla < 0) {
            return;
        }
        if ((cla & 0xE0) == 32) {
            return;
        }
        if (this.channel <= 3) {
            com[0] = (byte)(com[0] & 0xBC);
            com[0] = (byte)(com[0] | this.channel);
        } else if (this.channel <= 19) {
            com[0] = (byte)(com[0] & 0xB0);
            com[0] = (byte)(com[0] | 0x40);
            com[0] = (byte)(com[0] | this.channel - 4);
        } else {
            throw new RuntimeException("Unsupported channel number: " + this.channel);
        }
    }

    @Override
    public void close() throws CardException {
        if (this.getChannelNumber() == 0) {
            throw new IllegalStateException("Cannot close basic logical channel");
        }
        if (this.isClosed) {
            return;
        }
        this.card.checkExclusive();
        try {
            byte[] com = new byte[]{0, 112, -128, 0};
            com[3] = (byte)this.getChannelNumber();
            this.setChannel(com);
            byte[] res = PCSC.SCardTransmit(this.card.cardId, this.card.protocol, com, 0, com.length);
            if (!ChannelImpl.isOK(res)) {
                throw new CardException("close() failed: " + PCSC.toString(res));
            }
        }
        catch (PCSCException e) {
            this.card.handleError(e);
            throw new CardException("Could not close channel", e);
        }
        finally {
            this.isClosed = true;
        }
    }

    public String toString() {
        return "PC/SC channel " + this.channel;
    }
}

