/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import java.util.Map;
import org.openecard.addon.sal.FunctionType;
import org.openecard.addon.sal.ProtocolStep;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificate;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificateChain;
import org.openecard.crypto.common.asn1.eac.CADomainParameter;
import org.openecard.crypto.common.asn1.eac.CASecurityInfos;
import org.openecard.crypto.common.asn1.eac.SecurityInfos;
import org.openecard.crypto.common.asn1.eac.ef.EFCardAccess;
import org.openecard.crypto.common.asn1.utils.ObjectIdentifierUtils;
import org.openecard.sal.protocol.eac.TerminalAuthentication;
import org.openecard.sal.protocol.eac.anytype.EAC2InputType;
import org.openecard.sal.protocol.eac.anytype.EAC2OutputType;
import org.openecard.sal.protocol.eac.crypto.CAKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalAuthenticationStep
implements ProtocolStep<DIDAuthenticate, DIDAuthenticateResponse> {
    private static final Logger logger = LoggerFactory.getLogger(TerminalAuthenticationStep.class.getName());
    private Dispatcher dispatcher;

    public TerminalAuthenticationStep(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.DIDAuthenticate;
    }

    @Override
    public DIDAuthenticateResponse perform(DIDAuthenticate didAuthenticate, Map<String, Object> internalData) {
        DIDAuthenticateResponse response = new DIDAuthenticateResponse();
        byte[] slotHandle = didAuthenticate.getConnectionHandle().getSlotHandle();
        try {
            EAC2InputType eac2Input = new EAC2InputType(didAuthenticate.getAuthenticationProtocolData());
            EAC2OutputType eac2Output = eac2Input.getOutputType();
            TerminalAuthentication ta = new TerminalAuthentication(this.dispatcher, slotHandle);
            CardVerifiableCertificateChain certificateChain = (CardVerifiableCertificateChain)internalData.get("Certificates");
            certificateChain.addCertificates(eac2Input.getCertificates());
            byte[] currentCAR = (byte[])internalData.get("CurrentCAR");
            certificateChain = certificateChain.getCertificateChainFromCAR(currentCAR);
            ta.verifyCertificates(certificateChain);
            SecurityInfos securityInfos = (SecurityInfos)internalData.get("SecurityInfos");
            CardVerifiableCertificate terminalCertificate = certificateChain.getTerminalCertificates().get(0);
            byte[] oid = ObjectIdentifierUtils.getValue(terminalCertificate.getPublicKey().getObjectIdentifier());
            byte[] chr = terminalCertificate.getCHR().toByteArray();
            byte[] key = eac2Input.getEphemeralPublicKey();
            byte[] aad = (byte[])internalData.get("AuthenticatedAuxiliaryData");
            EFCardAccess efca = new EFCardAccess(securityInfos);
            CASecurityInfos cas = efca.getCASecurityInfos();
            CADomainParameter cdp = new CADomainParameter(cas);
            CAKey caKey = new CAKey(cdp);
            caKey.decodePublicKey(key);
            byte[] compKey = caKey.getEncodedCompressedPublicKey();
            ta.mseSetAT(oid, chr, compKey, aad);
            byte[] rPICC = ta.getChallenge();
            internalData.put("PKPCD", eac2Input.getEphemeralPublicKey());
            eac2Output.setChallenge(rPICC);
            response.setResult(WSHelper.makeResultOK());
            response.setAuthenticationProtocolData(eac2Output.getAuthDataType());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResultUnknownError(e.getMessage()));
        }
        return response;
    }
}

