/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openecard.gui.ResultStatus;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.OutputInfoUnit;
import org.openecard.gui.definition.Step;
import org.openecard.gui.swing.SwingStepResult;
import org.openecard.gui.swing.common.NavigationEvent;
import org.openecard.gui.swing.components.StepComponent;
import org.openecard.gui.swing.steplayout.StepLayouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepFrame {
    private static final Logger logger = LoggerFactory.getLogger(StepFrame.class);
    private static final long serialVersionUID = 1L;
    private JPanel panel = new JPanel();
    private Step step;
    private SwingStepResult stepResult;
    private List<StepComponent> components;
    private String dialogType;

    public StepFrame(Step step, String dialogType) {
        this.step = step;
        this.dialogType = dialogType;
        this.stepResult = new SwingStepResult(step);
        this.initLayout();
    }

    private void initLayout() {
        this.panel.setLayout(new BorderLayout());
    }

    private void initComponents() {
        StepLayouter stepLayouter = StepLayouter.create(this.step.getInputInfoUnits(), this.dialogType, this.step.getTitle());
        Container contentPanel = stepLayouter.getPanel();
        this.panel.add((Component)contentPanel, "Center");
        this.components = stepLayouter.getComponents();
    }

    public void resetResult() {
        this.stepResult = new SwingStepResult(this.step);
    }

    public boolean isInstantReturn() {
        return this.step.isInstantReturn();
    }

    public Container getPanel() {
        this.revalidate(this.panel);
        return this.panel;
    }

    public Step getStep() {
        return this.step;
    }

    public boolean validateComponents() {
        for (StepComponent next : this.components) {
            Component component = next.getComponent();
            if (next.isValueType() && !next.validate()) {
                component.setBackground(Color.RED);
                return false;
            }
            component.setBackground(null);
        }
        return true;
    }

    public List<OutputInfoUnit> getResultContent() {
        ArrayList<OutputInfoUnit> result = new ArrayList<OutputInfoUnit>(this.components.size());
        for (StepComponent next : this.components) {
            if (!next.isValueType()) continue;
            result.add(next.getValue());
        }
        return result;
    }

    public void updateFrame() {
        this.panel.removeAll();
        this.initComponents();
        this.revalidate(this.panel);
    }

    public StepResult getStepResult() {
        return this.stepResult;
    }

    private void revalidate(JComponent c) {
        for (int i = 0; i < c.getComponentCount(); ++i) {
            this.revalidate((JComponent)c.getComponent(i));
        }
        c.revalidate();
        c.repaint();
    }

    public void lockControls() {
    }

    public void unlockControls() {
    }

    public void updateResult(NavigationEvent event) {
        if (event == NavigationEvent.BACK) {
            this.stepResult.setResult(this.getResultContent());
            this.stepResult.setResultStatus(ResultStatus.BACK);
        } else if (event == NavigationEvent.NEXT) {
            this.stepResult.setResult(this.getResultContent());
            this.stepResult.setResultStatus(ResultStatus.OK);
        } else if (event == NavigationEvent.CANCEL) {
            this.stepResult.setResultStatus(ResultStatus.CANCEL);
        }
        try {
            logger.debug("Exchange result for step '{}", (Object)this.step.getTitle());
            this.stepResult.syncPoint.exchange(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

