/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.verify;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.openecard.bouncycastle.asn1.x500.RDN;
import org.openecard.bouncycastle.asn1.x500.style.BCStrictStyle;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.crypto.tls.CertificateVerificationException;
import org.openecard.crypto.tls.CertificateVerifier;

public class JavaSecVerifier
implements CertificateVerifier {
    private final KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
    private final CertPathValidator certPathValidator;

    public JavaSecVerifier() throws IOException, GeneralSecurityException {
        this.keyStore.load(null);
        KeyStore tmpKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
        String fSep = File.separator;
        File keyStoreFile = this.getKeystore(System.getProperty("java.home"), "lib" + fSep + "security" + fSep + "cacerts");
        if (keyStoreFile == null) {
            throw new FileNotFoundException("Unable to find system keystore in standard locations.");
        }
        tmpKeyStore.load(new FileInputStream(keyStoreFile), null);
        this.addKeyStore(tmpKeyStore);
    }

    private File getKeystore(String prefix, String fileName) {
        File f;
        if (fileName == null) {
            return null;
        }
        if (prefix != null) {
            fileName = prefix + File.separator + fileName;
        }
        if (!(f = new File(fileName)).canRead()) {
            return null;
        }
        return f;
    }

    public final void addKeyStore(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isCertificateEntry(alias)) continue;
            java.security.cert.Certificate cert = keyStore.getCertificate(alias);
            this.keyStore.setCertificateEntry(alias, cert);
        }
    }

    public final void addKeyStore(List<KeyStore> keyStores) throws KeyStoreException {
        for (KeyStore next : keyStores) {
            this.addKeyStore(next);
        }
    }

    @Override
    public void isValid(Certificate chain) throws CertificateVerificationException {
        this.isValid(chain, null);
    }

    @Override
    public void isValid(Certificate chain, String hostname) throws CertificateVerificationException {
        if (hostname != null) {
            org.openecard.bouncycastle.asn1.x509.Certificate cert = chain.getCertificateAt(0);
            RDN[] cn = cert.getSubject().getRDNs(BCStrictStyle.CN);
            if (cn.length != 1) {
                throw new CertificateVerificationException("Multiple CN entries in certificate's Subject.");
            }
            String hostNameReference = cn[0].getFirst().getValue().toString();
            JavaSecVerifier.checkWildcardName(hostname, hostNameReference);
        }
        try {
            CertPath certPath = this.convertChain(chain);
            PKIXParameters params = new PKIXParameters(this.keyStore);
            params.setRevocationEnabled(false);
            this.certPathValidator.validate(certPath, params);
        }
        catch (CertPathValidatorException ex) {
            throw new CertificateVerificationException(ex.getMessage());
        }
        catch (GeneralSecurityException ex) {
            throw new CertificateVerificationException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new CertificateVerificationException("Error converting certificate chain to java.security format.");
        }
    }

    private CertPath convertChain(Certificate chain) throws CertificateException, IOException {
        int numCerts = chain.getCertificateList().length;
        ArrayList<java.security.cert.Certificate> result = new ArrayList<java.security.cert.Certificate>(numCerts);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (org.openecard.bouncycastle.asn1.x509.Certificate next : chain.getCertificateList()) {
            byte[] nextData = next.getEncoded();
            ByteArrayInputStream nextDataStream = new ByteArrayInputStream(nextData);
            java.security.cert.Certificate nextConverted = cf.generateCertificate(nextDataStream);
            result.add(nextConverted);
        }
        return cf.generateCertPath(result);
    }

    private static void checkWildcardName(String givenHost, String wildcardHost) throws CertificateVerificationException {
        String[] wildToken;
        String errorMsg = "Hostname in certificate differs from actually requested host.";
        String[] givenToken = givenHost.split("\\.");
        if (givenToken.length != (wildToken = wildcardHost.split("\\.")).length) {
            throw new CertificateVerificationException("Hostname in certificate differs from actually requested host.");
        }
        for (int i = 0; i < givenToken.length; ++i) {
            if (wildToken[i].equals("*") || givenToken[i].equals(wildToken[i])) continue;
            throw new CertificateVerificationException("Hostname in certificate differs from actually requested host.");
        }
    }
}

