/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.auth;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.openecard.bouncycastle.crypto.tls.CertificateRequest;
import org.openecard.bouncycastle.crypto.tls.TlsCredentials;
import org.openecard.crypto.common.sal.CredentialNotFound;
import org.openecard.crypto.common.sal.GenericCryptoSigner;
import org.openecard.crypto.common.sal.GenericCryptoSignerFinder;
import org.openecard.crypto.tls.auth.CredentialFactory;
import org.openecard.crypto.tls.auth.SmartCardSignerCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardCredentialFactory
implements CredentialFactory {
    private static final Logger logger = LoggerFactory.getLogger(SmartCardCredentialFactory.class);
    private final GenericCryptoSignerFinder finder;
    private final List<TlsCredentials> credentials = new ArrayList<TlsCredentials>();

    public SmartCardCredentialFactory(@Nonnull GenericCryptoSignerFinder finder) {
        this.finder = finder;
    }

    @Override
    public List<TlsCredentials> getClientCredentials(CertificateRequest cr) {
        this.credentials.clear();
        try {
            GenericCryptoSigner result = this.finder.findFirstMatching(cr);
            SmartCardSignerCredential cred = new SmartCardSignerCredential(result);
            this.credentials.add(cred);
        }
        catch (CredentialNotFound e) {
            logger.error("No suitable credential found. Returning empty list.");
        }
        return this.credentials;
    }
}

