/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.sal;

import iso.std.iso_iec._24727.tech.schema.AlgorithmIdentifierType;
import iso.std.iso_iec._24727.tech.schema.AlgorithmInfoType;
import iso.std.iso_iec._24727.tech.schema.CertificateRefType;
import iso.std.iso_iec._24727.tech.schema.CryptoKeyInfoType;
import iso.std.iso_iec._24727.tech.schema.DIDAbstractMarkerType;
import iso.std.iso_iec._24727.tech.schema.HashGenerationInfoType;
import iso.std.iso_iec._24727.tech.schema.KeyRefType;
import iso.std.iso_iec._24727.tech.schema.StateInfo;
import java.math.BigInteger;
import java.util.Arrays;
import org.openecard.common.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CryptoMarkerType {
    private String legacyKeyName;
    private AlgorithmInfoType algorithmInfo;
    private HashGenerationInfoType hashGenerationInfo;
    private CertificateRefType certificateRef;
    private CryptoKeyInfoType cryptoKeyInfo;
    private String[] signatureGenerationInfo;
    private final String protocol;

    public CryptoMarkerType(DIDAbstractMarkerType baseType) {
        this.protocol = baseType.getProtocol();
        for (Element elem : baseType.getAny()) {
            Node n;
            NodeList nodeList;
            int i;
            if (elem.getLocalName().equals("AlgorithmInfo")) {
                this.algorithmInfo = new AlgorithmInfoType();
                NodeList algorithmInfoNodes = elem.getChildNodes();
                for (i = 0; i < algorithmInfoNodes.getLength(); ++i) {
                    Node node = algorithmInfoNodes.item(i);
                    if (node.getLocalName().equals("Algorithm")) {
                        this.algorithmInfo.setAlgorithm(node.getTextContent());
                        continue;
                    }
                    if (node.getLocalName().equals("AlgorithmIdentifier")) {
                        AlgorithmIdentifierType algorithmIdentifierType = new AlgorithmIdentifierType();
                        NodeList nodeList2 = node.getChildNodes();
                        for (int y = 0; y < nodeList2.getLength(); ++y) {
                            Node n2 = nodeList2.item(y);
                            if (n2.getLocalName().equals("Algorithm")) {
                                algorithmIdentifierType.setAlgorithm(n2.getTextContent());
                                continue;
                            }
                            if (!n2.getLocalName().equals("Parameters")) continue;
                            algorithmIdentifierType.setParameters(n2);
                        }
                        this.algorithmInfo.setAlgorithmIdentifier(algorithmIdentifierType);
                        continue;
                    }
                    if (node.getLocalName().equals("SupportedOperations")) {
                        String[] supportedOperations = node.getTextContent().split(" ");
                        this.algorithmInfo.getSupportedOperations().addAll(Arrays.asList(supportedOperations));
                        continue;
                    }
                    if (node.getLocalName().equals("CardAlgRef")) {
                        this.algorithmInfo.setCardAlgRef(StringUtils.toByteArray(node.getTextContent()));
                        continue;
                    }
                    if (!node.getLocalName().equals("HashAlgRef")) continue;
                    this.algorithmInfo.setHashAlgRef(StringUtils.toByteArray(node.getTextContent()));
                }
                continue;
            }
            if (elem.getLocalName().equals("KeyInfo")) {
                this.cryptoKeyInfo = new CryptoKeyInfoType();
                nodeList = elem.getChildNodes();
                for (i = 0; i < nodeList.getLength(); ++i) {
                    n = nodeList.item(i);
                    if (n.getLocalName().equals("KeyRef")) {
                        KeyRefType keyRef = new KeyRefType();
                        keyRef.setKeyRef(StringUtils.toByteArray(n.getTextContent()));
                        this.cryptoKeyInfo.setKeyRef(keyRef);
                        continue;
                    }
                    if (!n.getLocalName().equals("KeySize")) continue;
                    this.cryptoKeyInfo.setKeySize(new BigInteger(n.getTextContent()));
                }
                continue;
            }
            if (elem.getLocalName().equals("SignatureGenerationInfo")) {
                this.signatureGenerationInfo = elem.getTextContent().split(" ");
                continue;
            }
            if (elem.getLocalName().equals("HashGenerationInfo")) {
                this.hashGenerationInfo = HashGenerationInfoType.fromValue(elem.getTextContent());
                continue;
            }
            if (elem.getLocalName().equals("CertificateRef")) {
                this.certificateRef = new CertificateRefType();
                nodeList = elem.getChildNodes();
                for (i = 0; i < nodeList.getLength(); ++i) {
                    n = nodeList.item(i);
                    if (n.getLocalName().equals("DataSetName")) {
                        this.certificateRef.setDataSetName(n.getTextContent());
                        continue;
                    }
                    if (n.getLocalName().equals("DSIName")) {
                        this.certificateRef.setDSIName(n.getTextContent());
                        continue;
                    }
                    if (!n.getLocalName().equals("CertificateType")) continue;
                    this.certificateRef.setCertificateType(n.getTextContent());
                }
                continue;
            }
            if (elem.getLocalName().equals("LegacyKeyName")) {
                this.legacyKeyName = elem.getTextContent();
                continue;
            }
            if (!elem.getLocalName().equals("StateInfo")) continue;
        }
    }

    public String[] getSignatureGenerationInfo() {
        return (String[])this.signatureGenerationInfo.clone();
    }

    public CryptoKeyInfoType getCryptoKeyInfo() {
        return this.cryptoKeyInfo;
    }

    public String getLegacyKeyName() {
        return this.legacyKeyName;
    }

    public AlgorithmInfoType getAlgorithmInfo() {
        return this.algorithmInfo;
    }

    public HashGenerationInfoType getHashGenerationInfo() {
        return this.hashGenerationInfo;
    }

    public CertificateRefType getCertificateRef() {
        return this.certificateRef;
    }

    public StateInfo getStateInfo() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String getProtocol() {
        return this.protocol;
    }
}

