/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.util.Arrays;
import org.openecard.common.tlv.iso7816.DataCodingByte;
import org.openecard.common.tlv.iso7816.FileDescriptorByte;
import org.openecard.common.util.ByteUtils;

public class DataElement {
    private final FileDescriptorByte fdb;
    private final DataCodingByte dcb;
    private final int maxRecordSize;
    private final int numRecords;

    public DataElement(byte[] data) {
        this.fdb = new FileDescriptorByte(data[0]);
        this.dcb = data.length >= 2 ? new DataCodingByte(data[1]) : null;
        if (data.length >= 3) {
            this.maxRecordSize = ByteUtils.toInteger(Arrays.copyOfRange(data, 2, 4));
            this.numRecords = data.length > 4 ? ByteUtils.toInteger(Arrays.copyOfRange(data, 4, 6)) : -1;
        } else {
            this.maxRecordSize = -1;
            this.numRecords = -1;
        }
    }

    public FileDescriptorByte getFileDescriptorByte() {
        return this.fdb;
    }

    public boolean hasDataCodingByte() {
        return this.dcb != null;
    }

    public DataCodingByte getDataCodingByte() {
        return this.dcb;
    }

    public int getMaxRecordSize() {
        return this.maxRecordSize;
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public String toString(String prefix) {
        StringBuilder b = new StringBuilder(1024);
        b.append(prefix);
        b.append("DataElement:\n");
        b.append(this.fdb.toString(prefix + " "));
        b.append("\n");
        if (this.dcb != null) {
            b.append(this.dcb.toString(prefix + " "));
            b.append("\n");
        }
        b.append(prefix);
        b.append(" ");
        b.append("max-record-size=");
        b.append(this.getMaxRecordSize());
        b.append(" num-records=");
        b.append(this.getNumRecords());
        return b.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

