/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon.manifest;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.openecard.addon.manifest.LocalizedString;

@XmlTransient
public abstract class ConfigurationEntry {
    protected String key;
    protected final List<LocalizedString> localizedName = new ArrayList<LocalizedString>();
    protected final List<LocalizedString> localizedDescription = new ArrayList<LocalizedString>();

    @XmlElement(name="Key")
    public String getKey() {
        return this.key;
    }

    @XmlElement(name="LocalizedName")
    public List<LocalizedString> getLocalizedName() {
        return this.localizedName;
    }

    @XmlElement(name="LocalizedDescription")
    public List<LocalizedString> getLocalizedDescription() {
        return this.localizedDescription;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLocalizedName(String languageCode) {
        String fallback = "No localized Name found.";
        for (LocalizedString s : this.localizedName) {
            if (s.getLang().equalsIgnoreCase(languageCode)) {
                return s.getValue();
            }
            if (!s.getLang().equalsIgnoreCase("EN")) continue;
            fallback = s.getValue();
        }
        return fallback;
    }

    public String getLocalizedDescription(String languageCode) {
        String fallback = "No localized Description found.";
        for (LocalizedString s : this.localizedDescription) {
            if (s.getLang().equalsIgnoreCase(languageCode)) {
                return s.getValue();
            }
            if (!s.getLang().equalsIgnoreCase("EN")) continue;
            fallback = s.getValue();
        }
        return fallback;
    }
}

