/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.event;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.SlotStatusType;
import org.openecard.common.enums.EventType;
import org.openecard.event.EventManager;

public class Recognizer
implements Runnable {
    private final EventManager manager;
    private final EventType[] events;
    private final String ifdName;
    private final SlotStatusType status;

    public Recognizer(EventManager manager, String ifdName, SlotStatusType status, EventType ... events) {
        this.manager = manager;
        this.events = events;
        this.ifdName = ifdName;
        this.status = status;
    }

    @Override
    public void run() {
        if (this.events.length > 0) {
            ConnectionHandleType conHandle = this.manager.recognizeSlot(this.ifdName, this.status, false);
            ConnectionHandleType conHandleRecog = null;
            for (EventType type : this.events) {
                if (type.equals((Object)EventType.CARD_RECOGNIZED)) {
                    if (conHandleRecog != null) continue;
                    conHandleRecog = this.manager.recognizeSlot(this.ifdName, this.status, true);
                    this.manager.notify(type, conHandleRecog);
                    continue;
                }
                this.manager.notify(type, conHandle);
            }
        }
    }
}

