/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.cvc;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.bouncycastle.asn1.ASN1Set;
import org.openecard.bouncycastle.asn1.ASN1String;
import org.openecard.bouncycastle.asn1.ASN1TaggedObject;
import org.openecard.bouncycastle.asn1.DERIA5String;
import org.openecard.bouncycastle.asn1.DEROctetString;
import org.openecard.bouncycastle.asn1.DERSet;
import org.openecard.bouncycastle.asn1.DERTaggedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateDescription {
    private static final Logger _logger = LoggerFactory.getLogger(CertificateDescription.class);
    private String descriptionType;
    private String issuerName;
    private String issuerURL;
    private String subjectName;
    private String subjectURL;
    private Object termsOfUsage;
    private String redirectURL;
    private ArrayList<byte[]> commCertificates;
    private byte[] encoded;

    public static CertificateDescription getInstance(Object obj) throws CertificateException {
        if (obj instanceof CertificateDescription) {
            return (CertificateDescription)obj;
        }
        if (obj instanceof ASN1Set) {
            return new CertificateDescription((ASN1Sequence)obj);
        }
        if (obj instanceof byte[]) {
            try {
                return new CertificateDescription((ASN1Sequence)ASN1Sequence.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                _logger.error("Cannot parse CertificateDescription", e);
                throw new IllegalArgumentException("Cannot parse CertificateDescription");
            }
        }
        throw new IllegalArgumentException("Unknown object in factory: " + obj.getClass());
    }

    private CertificateDescription(ASN1Sequence seq) throws CertificateException {
        try {
            this.encoded = seq.getEncoded();
            Enumeration elements = seq.getObjects();
            this.descriptionType = ASN1ObjectIdentifier.getInstance(elements.nextElement()).toString();
            block11: while (elements.hasMoreElements()) {
                ASN1TaggedObject taggedObject = DERTaggedObject.getInstance(elements.nextElement());
                int tag = taggedObject.getTagNo();
                switch (tag) {
                    case 1: {
                        this.issuerName = ((ASN1String)((Object)taggedObject.getObject())).getString();
                        continue block11;
                    }
                    case 2: {
                        this.issuerURL = ((ASN1String)((Object)taggedObject.getObject())).getString();
                        continue block11;
                    }
                    case 3: {
                        this.subjectName = ((ASN1String)((Object)taggedObject.getObject())).getString();
                        continue block11;
                    }
                    case 4: {
                        this.subjectURL = ((ASN1String)((Object)taggedObject.getObject())).getString();
                        continue block11;
                    }
                    case 5: {
                        if (this.descriptionType.equals("0.4.0.127.0.7.3.1.3.1.1")) {
                            this.termsOfUsage = ((ASN1String)((Object)taggedObject.getObject())).getString();
                            continue block11;
                        }
                        if (this.descriptionType.equals("0.4.0.127.0.7.3.1.3.1.2")) {
                            this.termsOfUsage = ((DERIA5String)taggedObject.getObject()).getString();
                            continue block11;
                        }
                        if (!this.descriptionType.equals("0.4.0.127.0.7.3.1.3.1.3")) continue block11;
                        this.termsOfUsage = ((DEROctetString)taggedObject.getObject()).getEncoded();
                        continue block11;
                    }
                    case 6: {
                        this.redirectURL = ((ASN1String)((Object)taggedObject.getObject())).getString();
                        continue block11;
                    }
                    case 7: {
                        Enumeration commCerts = ((DERSet)taggedObject.getObject()).getObjects();
                        this.commCertificates = new ArrayList();
                        while (commCerts.hasMoreElements()) {
                            this.commCertificates.add(((DEROctetString)commCerts.nextElement()).getEncoded());
                        }
                        continue block11;
                    }
                }
                throw new IllegalArgumentException("Unknown object in CertificateDescription");
            }
        }
        catch (IOException e) {
            _logger.error("Cannot parse CertificateDescription", e);
            throw new CertificateException("Cannot parse CertificateDescription");
        }
    }

    public String getDescriptionType() {
        return this.descriptionType;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public String getIssuerURL() {
        return this.issuerURL;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public String getSubjectURL() {
        return this.subjectURL;
    }

    public Object getTermsOfUsage() {
        return this.termsOfUsage;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public ArrayList<byte[]> getCommCertificates() {
        return this.commCertificates;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }
}

