/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class HttpRequestLineUtils {
    public static Map<String, String> transformRaw(String queryStr) {
        String[] queries;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String query : queries = queryStr.split("&")) {
            String[] kv = query.split("=");
            if (kv.length == 1) {
                result.put(kv[0], null);
                continue;
            }
            if (kv.length != 2) continue;
            result.put(kv[0], kv[1]);
        }
        return result;
    }

    public static Map<String, String> transform(String queryStr) throws UnsupportedEncodingException {
        return HttpRequestLineUtils.transform(queryStr, "UTF-8");
    }

    public static Map<String, String> transform(String queryStr, String encoding) throws UnsupportedEncodingException {
        Map<String, String> result = HttpRequestLineUtils.transformRaw(queryStr);
        for (Map.Entry<String, String> next : result.entrySet()) {
            String v = next.getValue();
            if (v == null) continue;
            v = URLDecoder.decode(v, encoding);
            next.setValue(v);
        }
        return result;
    }
}

