/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.pqc.asn1;

import java.math.BigInteger;
import org.openecard.bouncycastle.asn1.ASN1EncodableVector;
import org.openecard.bouncycastle.asn1.ASN1Integer;
import org.openecard.bouncycastle.asn1.ASN1Object;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.ASN1OctetString;
import org.openecard.bouncycastle.asn1.ASN1Primitive;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.bouncycastle.asn1.DEROctetString;
import org.openecard.bouncycastle.asn1.DERSequence;
import org.openecard.bouncycastle.pqc.jcajce.spec.McElieceCCA2PrivateKeySpec;

public class McElieceCCA2PrivateKey
extends ASN1Object {
    private McElieceCCA2PrivateKeySpec keySpec;

    public McElieceCCA2PrivateKey(McElieceCCA2PrivateKeySpec keySpec) {
        this.keySpec = keySpec;
    }

    public McElieceCCA2PrivateKey(ASN1Sequence seq) {
        String oid = ((ASN1ObjectIdentifier)seq.getObjectAt(0)).getId();
        BigInteger bigN = ((ASN1Integer)seq.getObjectAt(1)).getValue();
        int n = bigN.intValue();
        BigInteger bigK = ((ASN1Integer)seq.getObjectAt(2)).getValue();
        int k = bigK.intValue();
        byte[] encField = ((ASN1OctetString)seq.getObjectAt(3)).getOctets();
        byte[] encGp = ((ASN1OctetString)seq.getObjectAt(4)).getOctets();
        byte[] encP = ((ASN1OctetString)seq.getObjectAt(5)).getOctets();
        byte[] encH = ((ASN1OctetString)seq.getObjectAt(6)).getOctets();
        ASN1Sequence asnQInv = (ASN1Sequence)seq.getObjectAt(7);
        byte[][] encqInv = new byte[asnQInv.size()][];
        for (int i = 0; i < asnQInv.size(); ++i) {
            encqInv[i] = ((ASN1OctetString)asnQInv.getObjectAt(i)).getOctets();
        }
        this.keySpec = new McElieceCCA2PrivateKeySpec(oid, n, k, encField, encGp, encP, encH, encqInv);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1ObjectIdentifier(this.keySpec.getOIDString()));
        v.add(new ASN1Integer(this.keySpec.getN()));
        v.add(new ASN1Integer(this.keySpec.getK()));
        v.add(new DEROctetString(this.keySpec.getField().getEncoded()));
        v.add(new DEROctetString(this.keySpec.getGoppaPoly().getEncoded()));
        v.add(new DEROctetString(this.keySpec.getP().getEncoded()));
        v.add(new DEROctetString(this.keySpec.getH().getEncoded()));
        ASN1EncodableVector asnQInv = new ASN1EncodableVector();
        for (int i = 0; i < this.keySpec.getQInv().length; ++i) {
            asnQInv.add(new DEROctetString(this.keySpec.getQInv()[i].getEncoded()));
        }
        v.add(new DERSequence(asnQInv));
        return new DERSequence(v);
    }

    public McElieceCCA2PrivateKeySpec getKeySpec() {
        return this.keySpec;
    }
}

