/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.bcpg.sig;

import java.util.Date;
import org.openecard.bouncycastle.bcpg.SignatureSubpacket;

public class SignatureCreationTime
extends SignatureSubpacket {
    protected static byte[] timeToBytes(Date date) {
        byte[] data = new byte[4];
        long t = date.getTime() / 1000L;
        data[0] = (byte)(t >> 24);
        data[1] = (byte)(t >> 16);
        data[2] = (byte)(t >> 8);
        data[3] = (byte)t;
        return data;
    }

    public SignatureCreationTime(boolean critical, byte[] data) {
        super(2, critical, data);
    }

    public SignatureCreationTime(boolean critical, Date date) {
        super(2, critical, SignatureCreationTime.timeToBytes(date));
    }

    public Date getTime() {
        long time = (long)(this.data[0] & 0xFF) << 24 | (long)((this.data[1] & 0xFF) << 16) | (long)((this.data[2] & 0xFF) << 8) | (long)(this.data[3] & 0xFF);
        return new Date(time * 1000L);
    }
}

