/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage.core;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.openecard.common.I18n;
import org.openecard.common.OpenecardProperties;
import org.openecard.common.io.ProxySettings;
import org.openecard.common.util.FileUtils;
import org.openecard.richclient.gui.manage.SettingsGroup;

public class ProxySettingsGroup
extends SettingsGroup {
    private static final long serialVersionUID = 1L;
    private static final I18n lang = I18n.getTranslation("addon");
    private static final String GROUP = "addon.list.core.connection.proxy.group_name";
    private static final String SCHEME = "addon.list.core.connection.proxy.scheme";
    private static final String SCHEME_DESC = "addon.list.core.connection.proxy.scheme.desc";
    private static final String HOST = "addon.list.core.connection.proxy.host";
    private static final String HOST_DESC = "addon.list.core.connection.proxy.host.desc";
    private static final String PORT = "addon.list.core.connection.proxy.port";
    private static final String PORT_DESC = "addon.list.core.connection.proxy.port.desc";
    private static final String VALI = "addon.list.core.connection.proxy.vali";
    private static final String VALI_DESC = "addon.list.core.connection.proxy.vali.desc";
    private static final String USER = "addon.list.core.connection.proxy.user";
    private static final String USER_DESC = "addon.list.core.connection.proxy.user.desc";
    private static final String PASS = "addon.list.core.connection.proxy.pass";
    private static final String PASS_DESC = "addon.list.core.connection.proxy.pass.desc";
    private final JComboBox selection = this.addSelectionItem(lang.translationForKey("addon.list.core.connection.proxy.scheme", new Object[0]), lang.translationForKey("addon.list.core.connection.proxy.scheme.desc", new Object[0]), "proxy.scheme", "", "SOCKS", "HTTP", "HTTPS");
    private final JTextField host = this.addInputItem(lang.translationForKey("addon.list.core.connection.proxy.host", new Object[0]), lang.translationForKey("addon.list.core.connection.proxy.host.desc", new Object[0]), "proxy.host");
    private final JTextField port = this.addInputItem(lang.translationForKey("addon.list.core.connection.proxy.port", new Object[0]), lang.translationForKey("addon.list.core.connection.proxy.port.desc", new Object[0]), "proxy.port");
    private final JCheckBox vali = this.addBoolItem(lang.translationForKey("addon.list.core.connection.proxy.vali", new Object[0]), lang.translationForKey("addon.list.core.connection.proxy.vali.desc", new Object[0]), "proxy.validate_tls");
    private final JTextField user = this.addInputItem(lang.translationForKey("addon.list.core.connection.proxy.user", new Object[0]), lang.translationForKey("addon.list.core.connection.proxy.user.desc", new Object[0]), "proxy.user");
    private final JTextField pass = this.addInputItem(lang.translationForKey("addon.list.core.connection.proxy.pass", new Object[0]), lang.translationForKey("addon.list.core.connection.proxy.pass.desc", new Object[0]), "proxy.pass");

    public ProxySettingsGroup() {
        super(lang.translationForKey(GROUP, new Object[0]), OpenecardProperties.properties());
        ItemManager manager = new ItemManager();
        Object selectedItem = this.selection.getSelectedItem();
        ItemEvent trigger = new ItemEvent(this.selection, 701, selectedItem, 1);
        manager.itemStateChanged(trigger);
        this.selection.addItemListener(manager);
    }

    @Override
    protected void saveProperties() throws IOException, SecurityException {
        File home = FileUtils.getHomeConfigDir();
        File config = new File(home, "openecard.properties");
        FileWriter writer = new FileWriter(config);
        this.properties.store(writer, null);
        OpenecardProperties.load();
        ProxySettings.load();
    }

    private class ItemManager
    implements ItemListener {
        private ItemManager() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Object val = e.getItem();
                if ("SOCKS".equals(val)) {
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.host, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.port, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.vali, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.user, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.pass, false);
                } else if ("HTTP".equals(val)) {
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.host, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.port, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.vali, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.user, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.pass, true);
                } else if ("HTTPS".equals(val)) {
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.host, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.port, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.vali, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.user, true);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.pass, true);
                } else {
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.host, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.port, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.vali, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.user, false);
                    ProxySettingsGroup.this.setEnabledComponent(ProxySettingsGroup.this.pass, false);
                }
            }
        }
    }
}

