/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient;

import ch.qos.logback.core.joran.spi.JoranException;
import iso.std.iso_iec._24727.tech.schema.EstablishContext;
import iso.std.iso_iec._24727.tech.schema.EstablishContextResponse;
import iso.std.iso_iec._24727.tech.schema.ReleaseContext;
import iso.std.iso_iec._24727.tech.schema.Terminate;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.security.Policy;
import javax.swing.JOptionPane;
import org.openecard.common.ClientEnv;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.ProtocolInfo;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.sal.state.SALStateCallback;
import org.openecard.common.util.FileUtils;
import org.openecard.control.ControlInterface;
import org.openecard.control.binding.http.HTTPBinding;
import org.openecard.control.binding.http.handler.HttpStatusHandler;
import org.openecard.control.binding.http.handler.HttpTCTokenHandler;
import org.openecard.control.binding.http.handler.HttpWaitForChangeHandler;
import org.openecard.control.handler.ControlHandlers;
import org.openecard.control.module.status.EventHandler;
import org.openecard.control.module.status.GenericStatusHandler;
import org.openecard.control.module.status.GenericWaitForChangeHandler;
import org.openecard.control.module.tctoken.GenericTCTokenHandler;
import org.openecard.event.EventManager;
import org.openecard.gui.swing.SwingDialogWrapper;
import org.openecard.gui.swing.SwingUserConsent;
import org.openecard.gui.swing.common.GUIDefaults;
import org.openecard.ifd.protocol.pace.PACEProtocolFactory;
import org.openecard.ifd.scio.IFD;
import org.openecard.management.TinyManagement;
import org.openecard.plugins.PluginPolicy;
import org.openecard.plugins.manager.PluginManager;
import org.openecard.plugins.pinplugin.PINPlugin;
import org.openecard.recognition.CardRecognition;
import org.openecard.richclient.LogbackConfig;
import org.openecard.richclient.gui.AppTray;
import org.openecard.richclient.gui.MessageDialog;
import org.openecard.sal.TinySAL;
import org.openecard.sal.protocol.eac.EAC2ProtocolFactory;
import org.openecard.sal.protocol.eac.EACGenericProtocolFactory;
import org.openecard.transport.dispatcher.MessageDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RichClient {
    private static final Logger _logger = LoggerFactory.getLogger(RichClient.class.getName());
    private static final I18n lang = I18n.getTranslation("richclient");
    private static RichClient client;
    private AppTray tray;
    private ControlInterface control;
    private ClientEnv env = new ClientEnv();
    private IFD ifd;
    private TinySAL sal;
    private EventManager em;
    private CardRecognition recognition;
    private CardStateMap cardStates;
    private byte[] contextHandle;
    private PluginManager pluginManager;

    public static void main(String[] args) {
        RichClient.getInstance();
    }

    public static synchronized RichClient getInstance() {
        if (client == null) {
            client = new RichClient();
            client.setup();
        }
        return client;
    }

    public void setup() {
        GUIDefaults.initialize();
        MessageDialog dialog = new MessageDialog();
        dialog.setHeadline(lang.translationForKey("client.startup.failed.headline", new Object[0]));
        try {
            this.tray = new AppTray(this);
            this.tray.beginSetup();
            this.env = new ClientEnv();
            TinyManagement management = new TinyManagement(this.env);
            this.env.setManagement(management);
            this.ifd = new IFD();
            this.ifd.addProtocol("urn:oid:0.4.0.127.0.7.2.2.4", new PACEProtocolFactory());
            this.env.setIFD(this.ifd);
            MessageDispatcher dispatcher = new MessageDispatcher(this.env);
            this.env.setDispatcher(dispatcher);
            this.ifd.setDispatcher(dispatcher);
            EstablishContext establishContext = new EstablishContext();
            EstablishContextResponse establishContextResponse = this.ifd.establishContext(establishContext);
            WSHelper.checkResult(establishContextResponse);
            this.contextHandle = this.ifd.establishContext(establishContext).getContextHandle();
            this.recognition = new CardRecognition(this.ifd, this.contextHandle);
            this.em = new EventManager(this.recognition, this.env, this.contextHandle);
            this.env.setEventManager(this.em);
            this.cardStates = new CardStateMap();
            SALStateCallback salCallback = new SALStateCallback(this.recognition, this.cardStates);
            this.em.registerAllEvents(salCallback);
            this.sal = new TinySAL(this.env, this.cardStates);
            this.sal.addProtocol("urn:oid:1.3.162.15480.3.0.14", new EACGenericProtocolFactory());
            this.sal.addProtocol("urn:oid:1.3.162.15480.3.0.14.2", new EAC2ProtocolFactory());
            this.env.setSAL(this.sal);
            SwingUserConsent gui = new SwingUserConsent(new SwingDialogWrapper());
            this.sal.setGUI(gui);
            this.ifd.setGUI(gui);
            this.tray.endSetup(this.recognition);
            this.em.registerAllEvents(this.tray.status());
            this.em.initialize();
            try {
                HTTPBinding binding = new HTTPBinding(24727);
                ControlHandlers handler = new ControlHandlers();
                GenericTCTokenHandler genericTCTokenHandler = new GenericTCTokenHandler(this.cardStates, dispatcher, gui, this.recognition);
                EventHandler eventHandler = new EventHandler(this.em);
                ProtocolInfo pInfo = this.sal.getProtocolInfo();
                GenericStatusHandler genericStatusHandler = new GenericStatusHandler(this.cardStates, eventHandler, pInfo, this.recognition);
                GenericWaitForChangeHandler genericWaitHandler = new GenericWaitForChangeHandler(eventHandler);
                HttpTCTokenHandler tcTokenHandler = new HttpTCTokenHandler(genericTCTokenHandler);
                HttpStatusHandler statusHandler = new HttpStatusHandler(genericStatusHandler);
                HttpWaitForChangeHandler waitHandler = new HttpWaitForChangeHandler(genericWaitHandler);
                handler.addControlHandler(tcTokenHandler);
                handler.addControlHandler(statusHandler);
                handler.addControlHandler(waitHandler);
                this.control = new ControlInterface(binding, handler);
                this.control.start();
            }
            catch (BindException e) {
                dialog.setMessage(lang.translationForKey("client.startup.failed.portinuse", new Object[0]));
                throw e;
            }
            String pluginsPath = FileUtils.getHomeConfigDir() + File.separator + "plugins" + File.separator;
            Policy.setPolicy(new PluginPolicy(pluginsPath));
            System.setSecurityManager(new SecurityManager());
            this.pluginManager = new PluginManager(dispatcher, gui, this.recognition, this.cardStates, pluginsPath);
            this.pluginManager.addPlugin(new PINPlugin());
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), e);
            if (dialog.getMessage() == null || dialog.getMessage().isEmpty()) {
                dialog.setMessage(e.getMessage());
            }
            JOptionPane.showMessageDialog(null, dialog, "Open eCard App", -1);
            this.teardown();
        }
    }

    public void teardown() {
        try {
            this.pluginManager.shutDown();
            this.control.stop();
            this.em.terminate();
            Terminate terminate = new Terminate();
            this.sal.terminate(terminate);
            ReleaseContext releaseContext = new ReleaseContext();
            releaseContext.setContextHandle(this.contextHandle);
            this.ifd.releaseContext(releaseContext);
        }
        catch (Exception ex) {
            _logger.error("Failed to stop Richclient.", ex);
        }
        System.exit(0);
    }

    static {
        try {
            LogbackConfig.load();
        }
        catch (IOException ex) {
            _logger.error("Failed to load logback config from user config.", ex);
        }
        catch (JoranException ex) {
            _logger.error("Failed to load logback config from user config.", ex);
        }
    }
}

