/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin.gui;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.util.ArrayList;
import java.util.List;
import org.openecard.common.I18n;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.executor.ExecutionEngine;
import org.openecard.plugins.pinplugin.RecognizedState;
import org.openecard.plugins.pinplugin.gui.CANEntryStep;
import org.openecard.plugins.pinplugin.gui.CANStepAction;
import org.openecard.plugins.pinplugin.gui.ChangePINStep;
import org.openecard.plugins.pinplugin.gui.PINStepAction;

public class ChangePINDialog {
    private final I18n lang = I18n.getTranslation("pinplugin");
    private static final String ERRORSTEP_UNKNOWN = "action.changepin.userconsent.errorstep.unknown";
    private static final String ERRORSTEP_DEACTIVATED = "action.changepin.userconsent.errorstep.deactivated";
    private static final String ERRORSTEP_BLOCKED = "action.changepin.userconsent.errorstep.blocked";
    private static final String SUCCESSSTEP_DESCRIPTION = "action.changepin.userconsent.successstep.description";
    private static final String CANSTEP_TITLE = "action.changepin.userconsent.canstep.title";
    private static final String PINSTEP_TITLE = "action.changepin.userconsent.pinstep.title";
    private static final String ERRORSTEP_TITLE = "action.changepin.userconsent.errorstep.title";
    private static final String SUCCESSSTEP_TITLE = "action.changepin.userconsent.successstep.title";
    private static final String TITLE = "action.changepin.userconsent.title";
    private final UserConsent gui;
    private final ConnectionHandleType conHandle;
    private RecognizedState state;
    private boolean capturePin;
    private Dispatcher dispatcher;

    public ChangePINDialog(UserConsent gui, Dispatcher dispatcher, ConnectionHandleType conHandle, RecognizedState state, boolean capturePin) {
        this.gui = gui;
        this.conHandle = conHandle;
        this.state = state;
        this.capturePin = capturePin;
        this.dispatcher = dispatcher;
    }

    private UserConsentDescription createUserConsentDescription() {
        UserConsentDescription uc = new UserConsentDescription(this.lang.translationForKey(TITLE, new Object[0]));
        uc.getSteps().addAll(this.createSteps());
        return uc;
    }

    private List<Step> createSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        if (this.state.equals((Object)RecognizedState.PIN_blocked) || this.state.equals((Object)RecognizedState.PIN_deactivated) || this.state.equals((Object)RecognizedState.UNKNOWN)) {
            Step errorStep = this.createErrorStep();
            steps.add(errorStep);
            return steps;
        }
        Step canStep = this.createCANStep();
        steps.add(canStep);
        Step changePINStep = this.createChangePINStep();
        steps.add(changePINStep);
        Step successStep = this.createSuccessStep();
        steps.add(successStep);
        return steps;
    }

    private Step createSuccessStep() {
        Step successStep = new Step("success", this.lang.translationForKey(SUCCESSSTEP_TITLE, new Object[0]));
        successStep.setReversible(false);
        Text i1 = new Text();
        i1.setText(this.lang.translationForKey(SUCCESSSTEP_DESCRIPTION, new Object[0]));
        successStep.getInputInfoUnits().add(i1);
        return successStep;
    }

    private Step createErrorStep() {
        Step errorStep = new Step("error", this.lang.translationForKey(ERRORSTEP_TITLE, new Object[0]));
        errorStep.setReversible(false);
        Text i1 = new Text();
        switch (this.state) {
            case PIN_blocked: {
                i1.setText(this.lang.translationForKey(ERRORSTEP_BLOCKED, new Object[0]));
                break;
            }
            case PIN_deactivated: {
                i1.setText(this.lang.translationForKey(ERRORSTEP_DEACTIVATED, new Object[0]));
                break;
            }
            default: {
                i1.setText(this.lang.translationForKey(ERRORSTEP_UNKNOWN, new Object[0]));
            }
        }
        errorStep.getInputInfoUnits().add(i1);
        return errorStep;
    }

    private Step createChangePINStep() {
        int retryCounter = this.getRetryCounterFromState(this.state);
        String title = this.lang.translationForKey(PINSTEP_TITLE, new Object[0]);
        ChangePINStep changePINStep = new ChangePINStep("pin-entry", title, this.capturePin, retryCounter, false, false);
        PINStepAction pinAction = new PINStepAction(this.capturePin, this.conHandle, this.dispatcher, changePINStep, retryCounter);
        changePINStep.setAction(pinAction);
        return changePINStep;
    }

    private Step createCANStep() {
        String title = this.lang.translationForKey(CANSTEP_TITLE, new Object[0]);
        CANEntryStep canStep = new CANEntryStep("can-entry", title, this.capturePin, this.state, false, false);
        CANStepAction pinAction = new CANStepAction(this.capturePin, this.conHandle, this.dispatcher, canStep, this.state);
        canStep.setAction(pinAction);
        return canStep;
    }

    public void show() {
        UserConsentNavigator ucr = this.gui.obtainNavigator(this.createUserConsentDescription());
        ExecutionEngine exec = new ExecutionEngine(ucr);
        exec.process();
    }

    private int getRetryCounterFromState(RecognizedState state) {
        if (state.equals((Object)RecognizedState.PIN_activated_RC3)) {
            return 3;
        }
        if (state.equals((Object)RecognizedState.PIN_activated_RC2)) {
            return 2;
        }
        if (state.equals((Object)RecognizedState.PIN_suspended)) {
            return 1;
        }
        return 0;
    }
}

