/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.jci.monitor.FilesystemAlterationMonitor;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.gui.UserConsent;
import org.openecard.plugins.PluginInterface;
import org.openecard.plugins.manager.JARFileFilter;
import org.openecard.plugins.manager.PluginDirectoryAlterationListener;
import org.openecard.plugins.manager.PluginProperties;
import org.openecard.plugins.wrapper.PluginDispatcher;
import org.openecard.plugins.wrapper.PluginUserConsent;
import org.openecard.recognition.CardRecognition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static final Logger logger = LoggerFactory.getLogger(PluginManager.class.getName());
    private static final String FALSE = Boolean.toString(false);
    private static final String TRUE = Boolean.toString(true);
    private static final String PLUGIN_ATTRIBUTE_NAME = "plugin-main";
    private static Map<PluginInterface, Boolean> loadedPlugins = new HashMap<PluginInterface, Boolean>();
    private static Map<String, PluginInterface> jarPaths = new HashMap<String, PluginInterface>();
    private final PluginDispatcher pluginDispatcher;
    private final PluginUserConsent gui;
    private final CardRecognition recognition;
    private final CardStateMap cardStates;
    private final String pluginsPath;
    private static PluginManager instance;
    private boolean jarLoadingSupported;

    public PluginManager(Dispatcher dispatcher, UserConsent gui, CardRecognition recognition, CardStateMap states, String pluginsPath) {
        instance = this;
        this.pluginDispatcher = new PluginDispatcher(dispatcher);
        this.gui = new PluginUserConsent(gui);
        this.recognition = recognition;
        this.cardStates = states;
        this.pluginsPath = pluginsPath;
        try {
            PluginProperties.loadProperties();
        }
        catch (IOException ex) {
            logger.error("Properties coudn't be loaded.", ex);
        }
        boolean bl = this.jarLoadingSupported = pluginsPath != null && !pluginsPath.trim().isEmpty();
        if (this.jarLoadingSupported) {
            this.createPluginsDirectoryIfNotExistent(pluginsPath);
        }
        if (this.jarLoadingSupported) {
            this.startFileMonitor(pluginsPath);
        }
    }

    public Map<String, PluginInterface> getJarPaths() {
        return Collections.unmodifiableMap(jarPaths);
    }

    private void startFileMonitor(String pluginsPath2) {
        File f = new File(this.pluginsPath);
        logger.debug("Starting FilesystemAlterationMonitor on Path: {}", (Object)f.getPath());
        FilesystemAlterationMonitor fam = new FilesystemAlterationMonitor();
        fam.addListener(f, new PluginDirectoryAlterationListener(this));
        fam.start();
    }

    public static PluginManager getInstance() {
        return instance;
    }

    public boolean deactivatePlugin(PluginInterface instance) {
        if (!loadedPlugins.containsKey(instance)) {
            logger.debug("Plugin {} coudn't be deactivated because it is not loaded.", (Object)instance.getName());
            return false;
        }
        if (!loadedPlugins.get(instance).booleanValue()) {
            logger.debug("Plugin {} is already deactivated.", (Object)instance.getName());
            return true;
        }
        instance.stop();
        loadedPlugins.put(instance, false);
        PluginProperties.setProperty(instance.getClass().getCanonicalName(), FALSE);
        return true;
    }

    public boolean activatePlugin(PluginInterface instance) {
        if (!loadedPlugins.containsKey(instance)) {
            logger.debug("Plugin {} coudn't be activated because it is not loaded.", (Object)instance.getName());
            return false;
        }
        if (loadedPlugins.get(instance).booleanValue()) {
            logger.debug("Plugin {} is already activated.", (Object)instance.getName());
            return true;
        }
        instance.initialize(this.pluginDispatcher, this.gui, this.recognition, this.cardStates);
        loadedPlugins.put(instance, true);
        PluginProperties.setProperty(instance.getClass().getCanonicalName(), TRUE);
        return true;
    }

    private void createPluginsDirectoryIfNotExistent(String pluginsPath) {
        boolean directoryCreated;
        File f = new File(pluginsPath);
        if (!f.exists() && !(directoryCreated = f.mkdir())) {
            logger.error("Directory {} coudn't be created. Disabling jar loading support.", (Object)f.getPath());
            this.jarLoadingSupported = false;
        }
    }

    public static Map<PluginInterface, Boolean> getLoadedPlugins() {
        return Collections.unmodifiableMap(loadedPlugins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPlugin(File file) {
        File destination;
        String classToLoad;
        JarFile jarFile;
        if (!this.jarLoadingSupported) {
            return false;
        }
        URL[] url = new URL[1];
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException e) {
            logger.error("Provided File is not a JarFile.", e);
            return false;
        }
        try {
            boolean copySuccess;
            classToLoad = this.getPluginEntryClass(jarFile);
            if (classToLoad == null) {
                logger.error("Manifest did not contain an entry for plugin main class: {}.", (Object)classToLoad);
                boolean e = false;
                return e;
            }
            destination = new File(this.pluginsPath + file.getName());
            if (!file.getPath().equals(destination.getPath()) && !(copySuccess = this.copyFile(file, destination))) {
                boolean ex2 = false;
                return ex2;
            }
            url[0] = destination.toURI().toURL();
        }
        catch (IOException ex) {
            logger.error("Failed to read manifest entry for plugin main class.", ex);
            boolean ex2 = false;
            return ex2;
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException ex) {
                logger.error("Failed to close jar file.", ex);
            }
        }
        URLClassLoader ucl = new URLClassLoader(url);
        try {
            Class<?> clazz = ucl.loadClass(classToLoad);
            Constructor<?>[] constructors = clazz.getConstructors();
            if (constructors.length != 1) {
                logger.error("There's only one constructor allowed in Plugin main class.");
                return false;
            }
            Constructor<?> constructor = clazz.getConstructors()[0];
            PluginInterface instance = (PluginInterface)constructor.newInstance(new Object[0]);
            if (TRUE.equals(PluginProperties.getProperty(instance.getClass().getCanonicalName()))) {
                instance.initialize(this.pluginDispatcher, this.gui, this.recognition, this.cardStates);
                loadedPlugins.put(instance, true);
            } else {
                loadedPlugins.put(instance, false);
            }
            jarPaths.put(destination.getPath(), instance);
        }
        catch (ClassNotFoundException ex) {
            logger.error("Failed to load plugin main class: {}.", (Object)classToLoad, (Object)ex);
            return false;
        }
        catch (InstantiationException ex) {
            logger.error("Failed to call constructor of plugin main class: {}.", (Object)classToLoad, (Object)ex);
            return false;
        }
        catch (IllegalAccessException ex) {
            logger.error("Failed to call constructor of plugin main class: {}.", (Object)classToLoad, (Object)ex);
            return false;
        }
        catch (IllegalArgumentException ex) {
            logger.error("Failed to call constructor of plugin main class: {}.", (Object)classToLoad, (Object)ex);
            return false;
        }
        catch (InvocationTargetException ex) {
            logger.error("Failed to call constructor of plugin main class: {}.", (Object)classToLoad, (Object)ex);
            return false;
        }
        return true;
    }

    private boolean copyFile(File file, File destination) {
        try {
            int len;
            FileInputStream in = new FileInputStream(file);
            FileOutputStream out = new FileOutputStream(destination);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            logger.debug("Copied File {} to {}.", (Object)file.getPath(), (Object)destination.getPath());
            return true;
        }
        catch (FileNotFoundException e) {
            logger.error("Opening of Input- or Outputstream failed.", e);
            return false;
        }
        catch (IOException e) {
            logger.error("Reading/Writing of Input-/Outputstream failed.", e);
            return false;
        }
    }

    public boolean addPlugin(URL url) {
        if (!this.jarLoadingSupported) {
            return false;
        }
        try {
            String fileName;
            InputStream input = url.openStream();
            try {
                fileName = this.getFileNameFromURL(url.toString(), ".jar");
            }
            catch (IndexOutOfBoundsException ex) {
                logger.error("Couldn't get filename from URL: {}", (Object)url, (Object)ex);
                return false;
            }
            return this.addPlugin(input, fileName);
        }
        catch (IOException e) {
            logger.error("Couldn't open Inputstream for {}", (Object)url, (Object)e);
            return false;
        }
    }

    private String getFileNameFromURL(String string, String fileEnding) {
        int slashIndex = string.lastIndexOf(47);
        int endingIndex = string.lastIndexOf(fileEnding);
        return string.substring(slashIndex + 1, endingIndex + fileEnding.length());
    }

    public boolean addPlugin(InputStream in, String fileName) {
        if (!this.jarLoadingSupported) {
            return false;
        }
        File destination = new File(this.pluginsPath + fileName);
        try {
            int len;
            FileOutputStream out = new FileOutputStream(destination);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            logger.error("Opening of Input- or Outputstream failed.", e);
            return false;
        }
        catch (IOException e) {
            logger.error("Reading/Writing of Input-/Outputstream failed.", e);
            return false;
        }
        return true;
    }

    public boolean addPlugin(PluginInterface instance) {
        if (TRUE.equals(PluginProperties.getProperty(instance.getClass().getCanonicalName()))) {
            instance.initialize(this.pluginDispatcher, this.gui, this.recognition, this.cardStates);
            loadedPlugins.put(instance, true);
        } else {
            loadedPlugins.put(instance, false);
        }
        return true;
    }

    public boolean unloadPlugin(PluginInterface instance) {
        if (loadedPlugins.get(instance).booleanValue()) {
            instance.stop();
        }
        loadedPlugins.remove(instance);
        return true;
    }

    public boolean removePluginJAR(File jar) {
        if (!jar.exists()) {
            logger.debug("No plugin with the given name in the plugin directory.");
            return false;
        }
        return jar.delete();
    }

    public void addPlugins(String path) {
        File[] jarFiles;
        if (!this.jarLoadingSupported) {
            return;
        }
        File directory = new File(path);
        if (!directory.exists() || !directory.isDirectory()) {
            logger.error("{} is not a directory or does not exist.", (Object)directory);
            return;
        }
        for (File f : jarFiles = directory.listFiles(new JARFileFilter())) {
            this.addPlugin(f);
        }
    }

    private String getPluginEntryClass(JarFile jarFile) throws IOException {
        Manifest manifest = jarFile.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(PLUGIN_ATTRIBUTE_NAME);
    }

    public void shutDown() {
        for (PluginInterface instance : loadedPlugins.keySet()) {
            PluginProperties.setProperty(instance.getClass().getCanonicalName(), Boolean.toString(loadedPlugins.get(instance)));
        }
        try {
            PluginProperties.saveProperties();
        }
        catch (IOException e) {
            logger.error("Properties coudn't be saved.", e);
        }
        for (PluginInterface instance : loadedPlugins.keySet()) {
            this.deactivatePlugin(instance);
        }
    }
}

