/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio;

import iso.std.iso_iec._24727.tech.schema.AltVUMessagesType;
import iso.std.iso_iec._24727.tech.schema.DisplayCapabilityType;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilities;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilitiesResponse;
import iso.std.iso_iec._24727.tech.schema.IFDCapabilitiesType;
import iso.std.iso_iec._24727.tech.schema.InputUnitType;
import iso.std.iso_iec._24727.tech.schema.KeyPadCapabilityType;
import iso.std.iso_iec._24727.tech.schema.OutputInfoType;
import iso.std.iso_iec._24727.tech.schema.PasswordAttributesType;
import iso.std.iso_iec._24727.tech.schema.PinInputType;
import iso.std.iso_iec._24727.tech.schema.Transmit;
import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import iso.std.iso_iec._24727.tech.schema.VerifyUser;
import iso.std.iso_iec._24727.tech.schema.VerifyUserResponse;
import java.math.BigInteger;
import java.util.List;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.apdu.common.CardCommandStatus;
import org.openecard.common.util.PINUtils;
import org.openecard.common.util.UtilException;
import org.openecard.gui.ResultStatus;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.executor.ExecutionEngine;
import org.openecard.gui.executor.StepAction;
import org.openecard.ifd.scio.IFD;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.NativePinStepAction;
import org.openecard.ifd.scio.wrapper.SCTerminal;
import org.openecard.ifd.scio.wrapper.SCWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AbstractTerminal {
    private static final Logger _logger = LoggerFactory.getLogger(AbstractTerminal.class);
    private final I18n lang = I18n.getTranslation("pace");
    private final IFD ifd;
    private final SCWrapper scwrapper;
    private final UserConsent gui;
    private final byte[] ctxHandle;
    private final BigInteger displayIdx;
    private IFDCapabilitiesType capabilities;
    private Boolean canBeep = null;
    private Boolean canBlink = null;
    private Boolean canDisplay = null;
    private Boolean canEnter = null;
    private BigInteger keyIdx = null;

    public AbstractTerminal(IFD ifd, SCWrapper scwrapper, UserConsent gui, byte[] ctxHandle, BigInteger displayIdx) {
        this.ifd = ifd;
        this.scwrapper = scwrapper;
        this.gui = gui;
        this.ctxHandle = ctxHandle;
        this.displayIdx = displayIdx;
    }

    public void output(String ifdName, OutputInfoType outInfo) throws IFDException {
        Boolean optic;
        this.getCapabilities(ifdName);
        BigInteger didx = outInfo.getDisplayIndex();
        if (didx == null) {
            didx = BigInteger.valueOf(0L);
        }
        String msg = outInfo.getMessage();
        BigInteger timeout = outInfo.getTimeout();
        Boolean acoustic = outInfo.isAcousticalSignal();
        if (acoustic == null) {
            acoustic = Boolean.FALSE;
        }
        if ((optic = outInfo.isOpticalSignal()) == null) {
            optic = Boolean.FALSE;
        }
        if (acoustic.booleanValue()) {
            if (this.canBeep() || this.isVirtual()) {
                this.beep();
            } else {
                IFDException ex = new IFDException("No device to output a beep available.");
                _logger.warn(ex.getMessage(), ex);
                throw ex;
            }
        }
        if (optic.booleanValue()) {
            if (this.canBlink() || this.isVirtual()) {
                this.blink();
            } else {
                IFDException ex = new IFDException("No device to output a blink available.");
                _logger.warn(ex.getMessage(), ex);
                throw ex;
            }
        }
        if (msg != null) {
            if (this.canDisplay() || this.isVirtual()) {
                this.display(msg, timeout);
            } else {
                IFDException ex = new IFDException("No device to output a message available.");
                _logger.warn(ex.getMessage(), ex);
                throw ex;
            }
        }
    }

    public VerifyUserResponse verifyUser(VerifyUser verify) throws IFDException {
        byte[] handle = verify.getSlotHandle();
        SCTerminal term = this.scwrapper.getTerminal(handle);
        this.getCapabilities(term.getName());
        List<String> protoList = this.capabilities.getSlotCapability().get(0).getProtocol();
        if (!protoList.contains("urn:oid:1.3.162.15480.3.0.9")) {
            throw new IFDException("PinCompare protocol is not supported by this IFD.");
        }
        InputUnitType inputUnit = verify.getInputUnit();
        AltVUMessagesType allMsgs = AbstractTerminal.getMessagesOrDefaults(verify.getAltVUMessages());
        BigInteger firstTimeout = verify.getTimeoutUntilFirstKey();
        firstTimeout = firstTimeout == null ? BigInteger.valueOf(60000L) : firstTimeout;
        BigInteger otherTimeout = verify.getTimeoutAfterFirstKey();
        otherTimeout = otherTimeout == null ? BigInteger.valueOf(15000L) : otherTimeout;
        byte[] template = verify.getTemplate();
        if (inputUnit.getBiometricInput() != null) {
            String msg = "Biometric authentication not supported by IFD.";
            IFDException ex = new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#unknownInputUnit", msg);
            _logger.warn(ex.getMessage(), ex);
            throw ex;
        }
        if (inputUnit.getPinInput() != null) {
            PinInputType pinInput = inputUnit.getPinInput();
            if (this.canNativePinVerify(handle)) {
                NativePinStepAction pinAction = new NativePinStepAction("enter-pin", pinInput, term, template);
                UserConsentDescription uc = this.pinUserConsent("step_pace_userconsent", pinAction);
                UserConsentNavigator ucr = this.gui.obtainNavigator(uc);
                ExecutionEngine exec = new ExecutionEngine(ucr);
                ResultStatus status = exec.process();
                if (status == ResultStatus.CANCEL) {
                    String msg = "PIN entry cancelled by user.";
                    IFDException ex = new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser", msg);
                    _logger.warn(ex.getMessage(), ex);
                    throw ex;
                }
                if (pinAction.exception != null) {
                    _logger.warn(pinAction.exception.getMessage(), pinAction.exception);
                    throw pinAction.exception;
                }
                byte[] verifyResponse = pinAction.response;
                Result result = AbstractTerminal.checkNativePinVerify(verifyResponse);
                VerifyUserResponse response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, result);
                response.setResponse(verifyResponse);
                return response;
            }
            if (this.isVirtual()) {
                Transmit verifyTransmit;
                int maxLength;
                int minLength = pinInput.getPasswordAttributes().getMinLength().intValue();
                UserConsentDescription uc = this.pinUserConsent("step_pace_userconsent", minLength, maxLength = pinInput.getPasswordAttributes().getMaxLength().intValue());
                UserConsentNavigator ucr = this.gui.obtainNavigator(uc);
                ExecutionEngine exec = new ExecutionEngine(ucr);
                ResultStatus status = exec.process();
                if (status == ResultStatus.CANCEL) {
                    String msg = "PIN entry cancelled by user.";
                    IFDException ex = new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser", msg);
                    _logger.warn(ex.getMessage(), ex);
                    throw ex;
                }
                String rawPIN = AbstractTerminal.getPinFromUserConsent(exec);
                PasswordAttributesType attributes = pinInput.getPasswordAttributes();
                try {
                    verifyTransmit = PINUtils.buildVerifyTransmit(rawPIN, attributes, template, handle);
                }
                catch (UtilException e) {
                    IFDException ex = new IFDException(e);
                    throw ex;
                }
                TransmitResponse transResp = this.ifd.transmit(verifyTransmit);
                if (transResp.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
                    if (transResp.getOutputAPDU().isEmpty()) {
                        IFDException ex = new IFDException(transResp.getResult());
                        _logger.warn(ex.getMessage(), ex);
                        throw ex;
                    }
                    VerifyUserResponse response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, transResp.getResult());
                    response.setResponse(transResp.getOutputAPDU().get(0));
                    return response;
                }
                VerifyUserResponse response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, transResp.getResult());
                response.setResponse(transResp.getOutputAPDU().get(0));
                return response;
            }
            IFDException ex = new IFDException("No input unit available to perform PinCompare protocol.");
            _logger.warn(ex.getMessage(), ex);
            throw ex;
        }
        IFDException ex = new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#unknownInputUnit", "Unsupported authentication input method requested.");
        _logger.warn(ex.getMessage(), ex);
        throw ex;
    }

    private static AltVUMessagesType getMessagesOrDefaults(AltVUMessagesType messages) {
        AltVUMessagesType allMsgs = new AltVUMessagesType();
        if (messages == null || messages.getAuthenticationRequestMessage() == null) {
            allMsgs.setAuthenticationRequestMessage("Enter secret:");
        } else {
            allMsgs.setAuthenticationRequestMessage(messages.getAuthenticationRequestMessage());
        }
        if (messages == null || messages.getSuccessMessage() == null) {
            allMsgs.setSuccessMessage("Secret entered successfully.");
        } else {
            allMsgs.setSuccessMessage(messages.getSuccessMessage());
        }
        if (messages == null || messages.getAuthenticationFailedMessage() == null) {
            allMsgs.setAuthenticationFailedMessage("Secret not entered successfully.");
        } else {
            allMsgs.setAuthenticationFailedMessage(messages.getAuthenticationFailedMessage());
        }
        if (messages == null || messages.getRequestConfirmationMessage() == null) {
            allMsgs.setRequestConfirmationMessage("Enter secret again:");
        } else {
            allMsgs.setRequestConfirmationMessage(messages.getRequestConfirmationMessage());
        }
        if (messages == null || messages.getCancelMessage() == null) {
            allMsgs.setCancelMessage("Canceled secret input.");
        } else {
            allMsgs.setCancelMessage(messages.getCancelMessage());
        }
        return allMsgs;
    }

    private void beep() {
        if (this.canBeep()) {
            // empty if block
        }
    }

    private void blink() {
        if (this.canBlink()) {
            // empty if block
        }
    }

    private void display(String msg, BigInteger timeout) {
        if (this.canDisplay()) {
            // empty if block
        }
    }

    private boolean canBeep() {
        if (this.canBeep == null) {
            this.canBeep = this.capabilities.isAcousticSignalUnit();
        }
        return this.canBeep;
    }

    private boolean canBlink() {
        if (this.canBlink == null) {
            this.canBlink = this.capabilities.isOpticalSignalUnit();
        }
        return this.canBlink;
    }

    private boolean canDisplay() {
        if (this.canDisplay == null) {
            this.canDisplay = Boolean.FALSE;
            if (this.displayIdx == null && !this.capabilities.getDisplayCapability().isEmpty()) {
                this.canDisplay = Boolean.TRUE;
            } else {
                for (DisplayCapabilityType disp : this.capabilities.getDisplayCapability()) {
                    if (!disp.getIndex().equals(this.displayIdx)) continue;
                    this.canDisplay = Boolean.TRUE;
                    break;
                }
            }
        }
        return this.canDisplay;
    }

    private DisplayCapabilityType getDisplayCapabilities() {
        if (this.canDisplay.booleanValue()) {
            if (this.displayIdx == null) {
                DisplayCapabilityType disp = this.capabilities.getDisplayCapability().get(0);
                return disp;
            }
            for (DisplayCapabilityType disp : this.capabilities.getDisplayCapability()) {
                if (!disp.getIndex().equals(this.displayIdx)) continue;
                return disp;
            }
            return null;
        }
        return null;
    }

    private boolean canEnter() {
        if (this.canEnter == null) {
            this.canEnter = Boolean.FALSE;
            if (this.keyIdx == null && !this.capabilities.getKeyPadCapability().isEmpty()) {
                this.canEnter = Boolean.TRUE;
            } else {
                for (KeyPadCapabilityType key : this.capabilities.getKeyPadCapability()) {
                    if (!key.getIndex().equals(this.keyIdx)) continue;
                    this.canEnter = Boolean.TRUE;
                    break;
                }
            }
        }
        return this.canEnter;
    }

    private KeyPadCapabilityType getKeypadCapabilities() {
        if (this.canEnter.booleanValue()) {
            if (this.keyIdx == null) {
                KeyPadCapabilityType key = this.capabilities.getKeyPadCapability().get(0);
                return key;
            }
            for (KeyPadCapabilityType key : this.capabilities.getKeyPadCapability()) {
                if (!key.getIndex().equals(this.keyIdx)) continue;
                return key;
            }
            return null;
        }
        return null;
    }

    private boolean isVirtual() {
        return this.gui != null;
    }

    private boolean canNativePinVerify(byte[] slotHandle) {
        try {
            SCTerminal term = this.scwrapper.getTerminal(slotHandle);
            return term.supportsPinCompare();
        }
        catch (IFDException ex) {
            return false;
        }
    }

    private static Result checkNativePinVerify(byte[] response) {
        byte sw1 = response[0];
        byte sw2 = response[1];
        if (sw1 == 100) {
            if (sw2 == 0) {
                return WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#timeoutError", "Verify operation timed out.");
            }
            if (sw2 == 1) {
                return WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser", "Verify operation was cancelled with the cancel button.");
            }
            if (sw2 == 2) {
                return WSHelper.makeResultUnknownError("Modify PIN operation failed because two PINs were different.");
            }
            if (sw2 == 3) {
                return WSHelper.makeResultUnknownError("PIN has wrong length.");
            }
        } else if (sw1 == 107) {
            if (sw2 == -128) {
                return WSHelper.makeResultUnknownError("Invalid parameter passed to verify command.");
            }
        } else if (sw1 == -112 && sw2 == 0) {
            return WSHelper.makeResultOK();
        }
        return WSHelper.makeResultUnknownError(CardCommandStatus.getMessage(response));
    }

    private void getCapabilities(String ifdName) throws IFDException {
        GetIFDCapabilities capabilitiesReq = new GetIFDCapabilities();
        capabilitiesReq.setContextHandle(this.ctxHandle);
        capabilitiesReq.setIFDName(ifdName);
        GetIFDCapabilitiesResponse cap = this.ifd.getIFDCapabilities(capabilitiesReq);
        Result r = cap.getResult();
        if (r.getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
            IFDException ex = new IFDException(r);
            _logger.warn(ex.getMessage(), ex);
            throw ex;
        }
        this.capabilities = cap.getIFDCapabilities();
    }

    private UserConsentDescription pinUserConsent(String title, int minLength, int maxLength) {
        UserConsentDescription uc = new UserConsentDescription(this.lang.translationForKey(title, new Object[0]));
        Step s = new Step("enter-pin", this.lang.translationForKey("step_pace_title", "PIN"));
        uc.getSteps().add(s);
        PasswordField i1 = new PasswordField("pin");
        s.getInputInfoUnits().add(i1);
        i1.setDescription("PIN:");
        i1.setMinLength(minLength);
        i1.setMaxLength(maxLength);
        return uc;
    }

    private UserConsentDescription pinUserConsent(String title, StepAction action) {
        UserConsentDescription uc = new UserConsentDescription(title);
        Step s = new Step("enter-pin", this.lang.translationForKey("step_pace_title", "PIN"));
        s.setAction(action);
        uc.getSteps().add(s);
        s.setInstantReturn(true);
        Text i1 = new Text();
        s.getInputInfoUnits().add(i1);
        i1.setText(this.lang.translationForKey("step_pace_native_description", "PIN"));
        return uc;
    }

    private static String getPinFromUserConsent(ExecutionEngine response) {
        PasswordField p = (PasswordField)response.getResults().get("enter-pin").getResult("pin");
        return p.getValue();
    }
}

