/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.openecard.bouncycastle.bcpg.BCPGInputStream;
import org.openecard.bouncycastle.bcpg.BCPGKey;
import org.openecard.bouncycastle.bcpg.BCPGObject;
import org.openecard.bouncycastle.bcpg.BCPGOutputStream;
import org.openecard.bouncycastle.bcpg.MPInteger;

public class DSASecretBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger x;

    public DSASecretBCPGKey(BCPGInputStream in) throws IOException {
        this.x = new MPInteger(in);
    }

    public DSASecretBCPGKey(BigInteger x) {
        this.x = new MPInteger(x);
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            BCPGOutputStream pgpOut = new BCPGOutputStream(bOut);
            pgpOut.writeObject(this);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writeObject(this.x);
    }

    public BigInteger getX() {
        return this.x.getValue();
    }
}

