/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import generated.TCTokenType;
import java.util.ArrayList;
import java.util.List;
import org.openecard.common.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TCTokenSAXHandler
extends DefaultHandler {
    private static final String TC_TOKEN_TYPE = "TCTokenType";
    private static final String SERVER_ADDRESS = "ServerAddress";
    private static final String SESSION_IDENTIFIER = "SessionIdentifier";
    private static final String REFRESH_ADDRESS = "RefreshAddress";
    private static final String PATH_SECURITY_PROTOCOL = "PathSecurity-Protocol";
    private static final String BINDING = "Binding";
    private static final String PATH_SECURITY_PARAMETERS = "PathSecurity-Parameters";
    private static final String PSK = "PSK";
    private boolean read;
    private StringBuilder sb;
    private List<TCTokenType> tokens;
    private TCTokenType token;

    @Override
    public void startDocument() throws SAXException {
        this.tokens = new ArrayList<TCTokenType>();
        this.sb = new StringBuilder(2048);
    }

    @Override
    public void endDocument() throws SAXException {
        this.token = null;
        this.read = false;
        this.sb.delete(0, this.sb.length());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase(TC_TOKEN_TYPE)) {
            this.read = true;
            this.token = new TCTokenType();
        } else if (qName.equalsIgnoreCase(PATH_SECURITY_PARAMETERS)) {
            this.token.setPathSecurityParameters(new TCTokenType.PathSecurityParameters());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value = this.sb.toString();
        this.sb.delete(0, this.sb.length());
        if (qName.equalsIgnoreCase(TC_TOKEN_TYPE)) {
            this.tokens.add(this.token);
            this.token = new TCTokenType();
            this.read = false;
        } else if (qName.equalsIgnoreCase(SESSION_IDENTIFIER)) {
            this.token.setSessionIdentifier(value);
        } else if (qName.equalsIgnoreCase(SERVER_ADDRESS)) {
            if (!value.startsWith("https://") && !value.startsWith("http://")) {
                value = "https://" + value;
            }
            this.token.setServerAddress(value);
        } else if (qName.equalsIgnoreCase(REFRESH_ADDRESS)) {
            this.token.setRefreshAddress(value);
        } else if (qName.equalsIgnoreCase(PATH_SECURITY_PROTOCOL)) {
            this.token.setPathSecurityProtocol(value);
        } else if (qName.equalsIgnoreCase(BINDING)) {
            this.token.setBinding(value);
        } else if (qName.equalsIgnoreCase(PSK)) {
            byte[] b = StringUtils.toByteArray(value.toUpperCase());
            this.token.getPathSecurityParameters().setPSK(b);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.read) {
            for (int i = start; i < start + length; ++i) {
                if (Character.isISOControl(ch[i]) || Character.isWhitespace(ch[i])) continue;
                this.sb.append(ch[i]);
            }
        }
    }

    public List<TCTokenType> getTCTokens() {
        return this.tokens;
    }
}

