/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.Path;
import org.openecard.common.tlv.iso7816.TLVBitString;
import org.openecard.common.tlv.iso7816.TLVType;
import org.openecard.common.util.ByteUtils;

public class PasswordAttributes
extends TLVType {
    private TLVBitString passwordFlags;
    private int passwordType;
    private int minLength;
    private int storedLength;
    private Integer maxLength;
    private Integer passwordReference;
    private Byte padChar;
    private TLV lastPasswordChange;
    private Path path;

    public PasswordAttributes(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv.getChild());
        if (!p.match(Tag.BITSTRING_TAG)) {
            throw new TLVException("passwordFlags element missing.");
        }
        this.passwordFlags = new TLVBitString(p.next(0));
        if (!p.match(Tag.ENUMERATED_TAG)) {
            throw new TLVException("passwordType element missing.");
        }
        this.passwordType = ByteUtils.toInteger(p.next(0).getValue());
        if (!p.match(Tag.INTEGER_TAG)) {
            throw new TLVException("minLength element missing.");
        }
        this.minLength = ByteUtils.toInteger(p.next(0).getValue());
        if (!p.match(Tag.INTEGER_TAG)) {
            throw new TLVException("storedLength element missing.");
        }
        this.storedLength = ByteUtils.toInteger(p.next(0).getValue());
        if (p.match(Tag.INTEGER_TAG)) {
            this.maxLength = ByteUtils.toInteger(p.next(0).getValue());
        }
        if (p.match(new Tag(TagClass.CONTEXT, true, 0L))) {
            this.passwordReference = ByteUtils.toInteger(p.next(0).getValue());
        }
        if (p.match(Tag.OCTETSTRING_TAG)) {
            this.padChar = p.next(0).getValue()[0];
        }
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 24L))) {
            this.lastPasswordChange = p.next(0);
        }
        if (p.match(Tag.SEQUENCE_TAG)) {
            this.path = new Path(p.next(0));
        }
    }
}

