/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.openecard.bouncycastle.crypto.BufferedBlockCipher;
import org.openecard.bouncycastle.crypto.StreamCipher;

public class CipherOutputStream
extends FilterOutputStream {
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private byte[] oneByte = new byte[1];
    private byte[] buf;

    public CipherOutputStream(OutputStream os, BufferedBlockCipher cipher) {
        super(os);
        this.bufferedBlockCipher = cipher;
        this.buf = new byte[cipher.getBlockSize()];
    }

    public CipherOutputStream(OutputStream os, StreamCipher cipher) {
        super(os);
        this.streamCipher = cipher;
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)b;
        if (this.bufferedBlockCipher != null) {
            int len = this.bufferedBlockCipher.processBytes(this.oneByte, 0, 1, this.buf, 0);
            if (len != 0) {
                this.out.write(this.buf, 0, len);
            }
        } else {
            this.out.write(this.streamCipher.returnByte((byte)b));
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.bufferedBlockCipher != null) {
            byte[] buf = new byte[this.bufferedBlockCipher.getOutputSize(len)];
            int outLen = this.bufferedBlockCipher.processBytes(b, off, len, buf, 0);
            if (outLen != 0) {
                this.out.write(buf, 0, outLen);
            }
        } else {
            byte[] buf = new byte[len];
            this.streamCipher.processBytes(b, off, len, buf, 0);
            this.out.write(buf, 0, len);
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            byte[] buf;
            int outLen;
            if (this.bufferedBlockCipher != null && (outLen = this.bufferedBlockCipher.doFinal(buf = new byte[this.bufferedBlockCipher.getOutputSize(0)], 0)) != 0) {
                this.out.write(buf, 0, outLen);
            }
        }
        catch (Exception e) {
            throw new IOException("Error closing stream: " + e.toString());
        }
        this.flush();
        super.close();
    }
}

