/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.util.ArrayList;
import java.util.List;
import org.openecard.common.tlv.iso7816.DataElement;

public class DataElements {
    private final List<DataElement> dataElements;

    public DataElements(List<byte[]> dataElements) {
        this.dataElements = new ArrayList<DataElement>(dataElements.size());
        for (byte[] next : dataElements) {
            this.dataElements.add(new DataElement(next));
        }
    }

    public boolean shareable() {
        if (!this.dataElements.isEmpty()) {
            return this.dataElements.get(0).getFileDescriptorByte().shareable();
        }
        return false;
    }

    public boolean isDF() {
        if (!this.dataElements.isEmpty()) {
            return this.dataElements.get(0).getFileDescriptorByte().isDF();
        }
        return false;
    }

    public boolean isEF() {
        if (!this.dataElements.isEmpty()) {
            return this.dataElements.get(0).getFileDescriptorByte().isEF();
        }
        return false;
    }

    public boolean isWorkingEF() {
        if (!this.dataElements.isEmpty()) {
            return this.dataElements.get(0).getFileDescriptorByte().isWorkingEF();
        }
        return false;
    }

    public boolean isInternalEF() {
        if (!this.dataElements.isEmpty()) {
            return this.dataElements.get(0).getFileDescriptorByte().isInternalEF();
        }
        return false;
    }

    public boolean isUnknownFormat() {
        if (!this.dataElements.isEmpty()) {
            return this.dataElements.get(0).getFileDescriptorByte().isUnknownFormat();
        }
        return false;
    }

    public boolean isTransparent() {
        for (DataElement next : this.dataElements) {
            if (!next.getFileDescriptorByte().isTransparent()) continue;
            return true;
        }
        return false;
    }

    public boolean isLinear() {
        for (DataElement next : this.dataElements) {
            if (!next.getFileDescriptorByte().isLinear()) continue;
            return true;
        }
        return false;
    }

    public boolean isCyclic() {
        for (DataElement next : this.dataElements) {
            if (!next.getFileDescriptorByte().isCyclic()) continue;
            return true;
        }
        return false;
    }

    public boolean isDataObject() {
        for (DataElement next : this.dataElements) {
            if (!next.getFileDescriptorByte().isDataObject()) continue;
            return true;
        }
        return false;
    }

    public String toString(String prefix) {
        StringBuilder b = new StringBuilder(4096);
        b.append("DataElements:");
        for (DataElement next : this.dataElements) {
            b.append("\n");
            b.append(next.toString(prefix + " "));
        }
        return b.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

