/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.DSA;
import org.openecard.bouncycastle.crypto.params.ECKeyParameters;
import org.openecard.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.openecard.bouncycastle.crypto.params.ParametersWithRandom;
import org.openecard.bouncycastle.math.ec.ECAlgorithms;
import org.openecard.bouncycastle.math.ec.ECCurve;
import org.openecard.bouncycastle.math.ec.ECFieldElement;
import org.openecard.bouncycastle.math.ec.ECPoint;

public class DSTU4145Signer
implements DSA {
    private ECKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                param = rParam.getParameters();
            } else {
                this.random = new SecureRandom();
            }
            this.key = (ECPrivateKeyParameters)param;
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger s;
        BigInteger r;
        ECFieldElement h = DSTU4145Signer.hash2FieldElement(this.key.getParameters().getCurve(), message);
        if (h.toBigInteger().signum() == 0) {
            h = this.key.getParameters().getCurve().fromBigInteger(BigInteger.ONE);
        }
        while (true) {
            BigInteger e = DSTU4145Signer.generateRandomInteger(this.key.getParameters().getN(), this.random);
            ECFieldElement Fe = this.key.getParameters().getG().multiply(e).getX();
            if (Fe.toBigInteger().signum() == 0) continue;
            ECFieldElement y = h.multiply(Fe);
            r = DSTU4145Signer.fieldElement2Integer(this.key.getParameters().getN(), y);
            if (r.signum() != 0 && (s = r.multiply(((ECPrivateKeyParameters)this.key).getD()).add(e).mod(this.key.getParameters().getN())).signum() != 0) break;
        }
        return new BigInteger[]{r, s};
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        if (r.signum() == 0 || s.signum() == 0) {
            return false;
        }
        if (r.compareTo(this.key.getParameters().getN()) >= 0 || s.compareTo(this.key.getParameters().getN()) >= 0) {
            return false;
        }
        ECFieldElement h = DSTU4145Signer.hash2FieldElement(this.key.getParameters().getCurve(), message);
        if (h.toBigInteger().signum() == 0) {
            h = this.key.getParameters().getCurve().fromBigInteger(BigInteger.ONE);
        }
        ECPoint R = ECAlgorithms.sumOfTwoMultiplies(this.key.getParameters().getG(), s, ((ECPublicKeyParameters)this.key).getQ(), r);
        ECFieldElement y = h.multiply(R.getX());
        return DSTU4145Signer.fieldElement2Integer(this.key.getParameters().getN(), y).compareTo(r) == 0;
    }

    private static BigInteger generateRandomInteger(BigInteger n, SecureRandom random) {
        return new BigInteger(n.bitLength() - 1, random);
    }

    private static void reverseBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length / 2; ++i) {
            byte tmp = bytes[i];
            bytes[i] = bytes[bytes.length - 1 - i];
            bytes[bytes.length - 1 - i] = tmp;
        }
    }

    private static ECFieldElement hash2FieldElement(ECCurve curve, byte[] hash) {
        byte[] data = (byte[])hash.clone();
        DSTU4145Signer.reverseBytes(data);
        BigInteger num = new BigInteger(1, data);
        while (num.bitLength() >= curve.getFieldSize()) {
            num = num.clearBit(num.bitLength() - 1);
        }
        return curve.fromBigInteger(num);
    }

    private static BigInteger fieldElement2Integer(BigInteger n, ECFieldElement fieldElement) {
        BigInteger num = fieldElement.toBigInteger();
        while (num.bitLength() >= n.bitLength()) {
            num = num.clearBit(num.bitLength() - 1);
        }
        return num;
    }
}

