/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.apache.http.protocol;

import java.io.IOException;
import org.openecard.apache.http.HttpEntityEnclosingRequest;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpRequestInterceptor;
import org.openecard.apache.http.annotation.ThreadSafe;
import org.openecard.apache.http.protocol.HttpContext;
import org.openecard.apache.http.protocol.HttpDateGenerator;

@ThreadSafe
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null.");
        }
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

