/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.apache.http.impl.pool;

import java.util.concurrent.atomic.AtomicLong;
import org.openecard.apache.http.HttpClientConnection;
import org.openecard.apache.http.HttpHost;
import org.openecard.apache.http.annotation.ThreadSafe;
import org.openecard.apache.http.impl.pool.BasicConnFactory;
import org.openecard.apache.http.impl.pool.BasicPoolEntry;
import org.openecard.apache.http.params.HttpParams;
import org.openecard.apache.http.pool.AbstractConnPool;
import org.openecard.apache.http.pool.ConnFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }
}

