/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ws.jaxb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openecard.ws.jaxb.MarshallerImpl;
import org.openecard.ws.jaxb.XMLStreamWriterWrapper;
import org.openecard.ws.marshal.MarshallingTypeException;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WhitespaceFilter;
import org.openecard.ws.soap.MessageFactory;
import org.openecard.ws.soap.SOAPBody;
import org.openecard.ws.soap.SOAPException;
import org.openecard.ws.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JAXBMarshaller
implements WSMarshaller {
    private static final Logger logger = LoggerFactory.getLogger(JAXBMarshaller.class);
    private final MarshallerImpl marshaller;
    private final DocumentBuilderFactory w3Factory;
    private final DocumentBuilder w3Builder;
    private final Transformer serializer;
    private final MessageFactory soapFactory;

    public JAXBMarshaller() {
        MarshallerImpl tmpMarshaller = null;
        DocumentBuilderFactory tmpW3Factory = null;
        DocumentBuilder tmpW3Builder = null;
        Transformer tmpSerializer = null;
        MessageFactory tmpSoapFactory = null;
        try {
            tmpMarshaller = new MarshallerImpl();
            tmpW3Factory = DocumentBuilderFactory.newInstance();
            tmpW3Factory.setNamespaceAware(true);
            tmpW3Factory.setIgnoringComments(true);
            tmpW3Builder = tmpW3Factory.newDocumentBuilder();
            TransformerFactory tfactory = TransformerFactory.newInstance();
            tmpSerializer = tfactory.newTransformer();
            tmpSerializer.setOutputProperty("indent", "yes");
            tmpSerializer.setOutputProperty("standalone", "yes");
            tmpSerializer.setOutputProperty("encoding", "UTF-8");
            tmpSerializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            tmpSoapFactory = MessageFactory.newInstance();
        }
        catch (Exception ex) {
            logger.error("Failed to initialize XML components.", ex);
            System.exit(1);
        }
        this.marshaller = tmpMarshaller;
        this.w3Factory = tmpW3Factory;
        this.w3Builder = tmpW3Builder;
        this.serializer = tmpSerializer;
        this.soapFactory = tmpSoapFactory;
    }

    @Override
    public void addXmlTypeClass(Class xmlTypeClass) throws MarshallingTypeException {
        this.marshaller.addXmlClass(xmlTypeClass);
    }

    @Override
    public void removeAllTypeClasses() {
        this.marshaller.removeAllClasses();
    }

    @Override
    public synchronized Document str2doc(String docStr) throws SAXException {
        try {
            StringReader strReader = new StringReader(docStr);
            InputSource inSrc = new InputSource(strReader);
            Document doc = this.w3Builder.parse(inSrc);
            WhitespaceFilter.filter(doc);
            return doc;
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public synchronized Document str2doc(InputStream docStr) throws SAXException, IOException {
        Document doc = this.w3Builder.parse(docStr);
        WhitespaceFilter.filter(doc);
        return doc;
    }

    @Override
    public synchronized String doc2str(Node doc) throws TransformerException {
        String result;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializer.transform(new DOMSource(doc), new StreamResult(out));
        try {
            result = out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new TransformerException(ex);
        }
        return result;
    }

    @Override
    public synchronized Object unmarshal(Node n) throws MarshallingTypeException, WSMarshallerException {
        Object result;
        Document newDoc = null;
        if (n instanceof Document) {
            newDoc = (Document)n;
        } else if (n instanceof Element) {
            newDoc = this.w3Builder.newDocument();
            Node root = newDoc.importNode(n, true);
            newDoc.appendChild(root);
        } else {
            throw new WSMarshallerException("Only w3c Document and Element are accepted.");
        }
        try {
            result = this.marshaller.getUnmarshaller().unmarshal((Node)newDoc);
        }
        catch (JAXBException ex) {
            throw new MarshallingTypeException(ex);
        }
        return result;
    }

    @Override
    public synchronized Document marshal(Object o) throws MarshallingTypeException {
        try {
            StringWriter sw = new StringWriter();
            XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(sw);
            XMLStreamWriterWrapper xmlwrap = new XMLStreamWriterWrapper(xmlStreamWriter);
            this.marshaller.getMarshaller().marshal(o, (XMLStreamWriter)xmlwrap);
            return this.str2doc(sw.toString());
        }
        catch (Exception ex) {
            throw new MarshallingTypeException(ex);
        }
    }

    @Override
    public synchronized SOAPMessage doc2soap(Document envDoc) throws SOAPException {
        SOAPMessage msg = this.soapFactory.createMessage(envDoc);
        return msg;
    }

    @Override
    public synchronized SOAPMessage add2soap(Document content) throws SOAPException {
        SOAPMessage msg = this.soapFactory.createMessage();
        SOAPBody body = msg.getSOAPBody();
        body.addDocument(content);
        return msg;
    }
}

