/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import org.openecard.bouncycastle.asn1.ASN1Object;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.ASN1Sequence;

public class AlgorithmIdentifier {
    private String algorithm;
    private ASN1Object parameters;

    public AlgorithmIdentifier(ASN1Sequence seq) {
        if (seq.size() == 1) {
            this.algorithm = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0)).toString();
        } else if (seq.size() == 2) {
            this.algorithm = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0)).toString();
            this.parameters = (ASN1Object)seq.getObjectAt(1);
        } else {
            throw new IllegalArgumentException("Sequence wrong size for AlgorithmIdentifier");
        }
    }

    public static AlgorithmIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof AlgorithmIdentifier) {
            return (AlgorithmIdentifier)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new AlgorithmIdentifier((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Unknown object in factory: " + obj.getClass().getName());
    }

    public String getObjectIdentifier() {
        return this.algorithm;
    }

    public ASN1Object getParameters() {
        return this.parameters;
    }
}

