/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openecard.common.util.FileUtils;

public class Version {
    private static final String versionFile = "openecard/VERSION";
    private static final String unknownVersion = "UNKNOWN";
    private static final String version;
    private static final int major;
    private static final int minor;
    private static final int patch;
    private static final String buildId;

    private static String loadVersionLine(InputStream in) {
        if (in == null) {
            return unknownVersion;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        try {
            String line = r.readLine();
            if (line == null) {
                return unknownVersion;
            }
            return line;
        }
        catch (IOException ex) {
            return unknownVersion;
        }
    }

    private static String[] splitVersion(String version) {
        String[] groups = new String[4];
        Pattern p = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(-.+)?");
        Matcher m = p.matcher(version);
        if (m.matches() && m.groupCount() >= 3) {
            groups[0] = m.group(1);
            groups[1] = m.group(2);
            groups[2] = m.group(3);
            groups[3] = m.group(4);
            if (groups[3] != null) {
                groups[3] = groups[3].substring(1);
            }
        } else {
            groups[0] = "0";
            groups[1] = "0";
            groups[2] = "0";
            groups[3] = null;
        }
        return groups;
    }

    public static String getVersion() {
        return version;
    }

    public static int getMajor() {
        return major;
    }

    public static int getMinor() {
        return minor;
    }

    public static int getPatch() {
        return patch;
    }

    public static String getBuildId() {
        return buildId;
    }

    static {
        InputStream in;
        try {
            in = FileUtils.resolveResourceAsStream(Version.class, versionFile);
        }
        catch (IOException ex) {
            in = null;
        }
        version = Version.loadVersionLine(in);
        String[] groups = Version.splitVersion(version);
        major = Integer.parseInt(groups[0]);
        minor = Integer.parseInt(groups[1]);
        patch = Integer.parseInt(groups[2]);
        buildId = groups[3];
    }
}

