/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.openecard.common.OverridingProperties;
import org.openecard.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenecardProperties {
    private static final Logger _logger = LoggerFactory.getLogger(OpenecardProperties.class);
    private static Internal properties;

    public static synchronized void load() {
        FileInputStream homeProps = null;
        InputStream bundledProps = null;
        try {
            File homePath = FileUtils.getHomeConfigDir();
            File cfgFile = new File(homePath, "openecard.properties");
            homeProps = new FileInputStream(cfgFile);
        }
        catch (IOException ex) {
            _logger.info("Failed to load bundled properties.", ex);
        }
        try {
            String fileName = "openecard_config/openecard.properties";
            bundledProps = FileUtils.resolveResourceAsStream(OpenecardProperties.class, fileName);
        }
        catch (IOException ex) {
            _logger.info("Failed to load properties from config dir.", ex);
        }
        try {
            properties = new Internal(bundledProps, homeProps);
        }
        catch (IOException ex) {
            _logger.error(ex.getMessage(), ex);
        }
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static Properties properties() {
        return properties.properties();
    }

    static {
        OpenecardProperties.load();
    }

    private static class Internal
    extends OverridingProperties {
        public Internal(InputStream bundledProps, InputStream homeProps) throws IOException {
            super(bundledProps, homeProps);
        }
    }
}

