/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.IOException;
import org.openecard.bouncycastle.crypto.tls.AbstractTlsClient;
import org.openecard.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import org.openecard.bouncycastle.crypto.tls.TlsCipher;
import org.openecard.bouncycastle.crypto.tls.TlsCipherFactory;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsPSKIdentity;
import org.openecard.bouncycastle.crypto.tls.TlsPSKKeyExchange;

public abstract class PSKTlsClient
extends AbstractTlsClient {
    protected TlsCipherFactory cipherFactory;
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsPSKIdentity pskIdentity, String fqdn) {
        this(new DefaultTlsCipherFactory(), pskIdentity, fqdn);
    }

    public PSKTlsClient(TlsCipherFactory cipherFactory, TlsPSKIdentity pskIdentity, String fqdn) {
        super(fqdn);
        this.cipherFactory = cipherFactory;
        this.pskIdentity = pskIdentity;
    }

    public static int[] getDefaultCipherSuites() {
        return new int[]{145, 144, 143, 149, 148, 147, 141, 140, 139};
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{145, 144, 143, 142, 149, 148, 147, 146, 141, 140, 139, 138};
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 138: 
            case 139: 
            case 140: 
            case 141: {
                return this.createPSKKeyExchange(13);
            }
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                return this.createPSKKeyExchange(15);
            }
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                return this.createPSKKeyExchange(14);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 139: 
            case 143: 
            case 147: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 140: 
            case 144: 
            case 148: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 141: 
            case 145: 
            case 149: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
            case 138: 
            case 142: 
            case 146: {
                return this.cipherFactory.createCipher(this.context, 2, 2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange) {
        return new TlsPSKKeyExchange(this.context, keyExchange, this.pskIdentity);
    }
}

