/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.apache.http.message;

import java.io.Serializable;
import org.openecard.apache.http.Header;
import org.openecard.apache.http.HeaderElement;
import org.openecard.apache.http.ParseException;
import org.openecard.apache.http.annotation.Immutable;
import org.openecard.apache.http.message.BasicHeaderValueParser;
import org.openecard.apache.http.message.BasicLineFormatter;

@Immutable
public class BasicHeader
implements Header,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5427236326487562174L;
    private final String name;
    private final String value;

    public BasicHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return BasicLineFormatter.DEFAULT.formatHeader(null, this).toString();
    }

    public HeaderElement[] getElements() throws ParseException {
        if (this.value != null) {
            return BasicHeaderValueParser.parseElements(this.value, null);
        }
        return new HeaderElement[0];
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

