/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.apache.http.impl.entity;

import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpMessage;
import org.openecard.apache.http.ProtocolException;
import org.openecard.apache.http.annotation.Immutable;
import org.openecard.apache.http.entity.ContentLengthStrategy;

@Immutable
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

