/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.manager;

import java.io.File;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationObserver;
import org.openecard.plugins.PluginInterface;
import org.openecard.plugins.manager.PluginManager;

final class PluginDirectoryAlterationListener
implements FilesystemAlterationListener {
    private final PluginManager pluginManager;

    PluginDirectoryAlterationListener(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    @Override
    public void onFileDelete(File file) {
        PluginInterface instance = this.pluginManager.getJarPaths().get(file.getPath());
        if (instance != null) {
            this.pluginManager.unloadPlugin(instance);
        }
    }

    @Override
    public void onFileCreate(File file) {
        if (this.pluginManager.getJarPaths().get(file.getPath()) == null) {
            this.pluginManager.addPlugin(file);
        }
    }

    @Override
    public void onStop(FilesystemAlterationObserver observer) {
    }

    @Override
    public void onStart(FilesystemAlterationObserver observer) {
    }

    @Override
    public void onFileChange(File file) {
    }

    @Override
    public void onDirectoryDelete(File file) {
    }

    @Override
    public void onDirectoryCreate(File file) {
    }

    @Override
    public void onDirectoryChange(File file) {
    }
}

