/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import org.openecard.common.util.ByteUtils;

public class LongUtils {
    public static byte[] toByteArray(long value) {
        return LongUtils.toByteArray(value, 8);
    }

    public static byte[] toByteArray(long value, int numBits) {
        if (value < 0L) {
            throw new IllegalArgumentException("Value must not be negative.");
        }
        if (numBits <= 0 || numBits > 8) {
            throw new IllegalArgumentException("Numbits must be between 0 and 8.");
        }
        if (value == 0L) {
            return new byte[1];
        }
        byte[] buffer = null;
        int numBytesInBuffer = 64 / numBits;
        int restBits = 64 - numBytesInBuffer * numBits;
        int j = 0;
        for (int i = numBytesInBuffer - (restBits > 0 ? 0 : 1); i >= 0; --i) {
            byte b;
            byte mask;
            if (i == numBytesInBuffer) {
                mask = LongUtils.numBitsToMask((byte)restBits);
                b = (byte)((byte)(value >> (i - 1) * numBits + restBits) & mask);
            } else {
                mask = LongUtils.numBitsToMask((byte)numBits);
                b = (byte)(value >> i * numBits & (long)mask);
            }
            if (buffer == null && b != 0) {
                buffer = new byte[i + 1];
            } else if (buffer == null) continue;
            buffer[j] = b;
            ++j;
        }
        return buffer;
    }

    private static byte numBitsToMask(byte numBits) {
        byte result = 0;
        for (byte i = 0; i < numBits; i = (byte)(i + 1)) {
            result = (byte)(result << 1 | 1);
        }
        return result;
    }

    public static byte[] toByteArray(long value, boolean padArrayToTypeLength) {
        byte[] result = LongUtils.toByteArray(value, 8);
        if (padArrayToTypeLength && result.length < 8) {
            result = ByteUtils.concatenate(new byte[8 - result.length], result);
        }
        return result;
    }
}

