/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.asn1.x509;

import java.io.IOException;
import org.openecard.bouncycastle.asn1.ASN1InputStream;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.ASN1Primitive;
import org.openecard.bouncycastle.asn1.DERPrintableString;
import org.openecard.bouncycastle.util.Strings;

public abstract class X509NameEntryConverter {
    protected ASN1Primitive convertHexEncoded(String str, int off) throws IOException {
        str = Strings.toLowerCase(str);
        byte[] data = new byte[(str.length() - off) / 2];
        for (int index = 0; index != data.length; ++index) {
            char left = str.charAt(index * 2 + off);
            char right = str.charAt(index * 2 + off + 1);
            data[index] = left < 'a' ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4);
            if (right < 'a') {
                int n = index;
                data[n] = (byte)(data[n] | (byte)(right - 48));
                continue;
            }
            int n = index;
            data[n] = (byte)(data[n] | (byte)(right - 97 + 10));
        }
        ASN1InputStream aIn = new ASN1InputStream(data);
        return aIn.readObject();
    }

    protected boolean canBePrintable(String str) {
        return DERPrintableString.isPrintableString(str);
    }

    public abstract ASN1Primitive getConvertedValue(ASN1ObjectIdentifier var1, String var2);
}

