/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.transport.dispatcher;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.TreeMap;
import org.openecard.common.interfaces.Dispatchable;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.common.interfaces.Environment;
import org.openecard.transport.dispatcher.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDispatcher
implements Dispatcher {
    private static final Logger logger = LoggerFactory.getLogger(MessageDispatcher.class);
    private final Environment environment;
    private final TreeMap<String, Service> serviceMap;
    private final TreeMap<String, Method> serviceInstMap;

    public MessageDispatcher(Environment environment) {
        this.environment = environment;
        this.serviceMap = new TreeMap();
        this.serviceInstMap = new TreeMap();
        this.initDefinitions();
    }

    @Override
    public Object deliver(Object req) throws DispatcherException, InvocationTargetException {
        try {
            Class<?> reqClass = req.getClass();
            Service s = this.getService(reqClass);
            Object serviceImpl = this.getServiceImpl(s);
            Object result = s.invoke(serviceImpl, req);
            return result;
        }
        catch (IllegalAccessException ex) {
            throw new DispatcherException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new DispatcherException(ex);
        }
    }

    private Service getService(Class reqClass) throws IllegalAccessException {
        if (!this.serviceMap.containsKey(reqClass.getName())) {
            String msg = "No service with a method containing parameter type " + reqClass.getName() + " present.";
            throw new IllegalAccessException(msg);
        }
        return this.serviceMap.get(reqClass.getName());
    }

    private Object getServiceImpl(Service s) throws IllegalAccessException, InvocationTargetException {
        Method m = this.serviceInstMap.get(s.getServiceInterface().getName());
        if (m == null) {
            String msg = "The environment does not contain a service for class " + s.getServiceInterface().getName();
            throw new IllegalAccessException(msg);
        }
        Object impl = m.invoke((Object)this.environment, new Object[0]);
        return impl;
    }

    private void initDefinitions() {
        Method[] envMethods;
        Class<?> envClass = this.environment.getClass();
        for (Method nextAccessor : envMethods = envClass.getMethods()) {
            int modifier;
            if (nextAccessor.getAnnotation(Dispatchable.class) == null || Modifier.isAbstract(modifier = nextAccessor.getModifiers()) || !Modifier.isPublic(modifier) || Modifier.isStatic(modifier)) continue;
            Dispatchable methodAnnotation = nextAccessor.getAnnotation(Dispatchable.class);
            Class returnType = methodAnnotation.interfaceClass();
            if (this.serviceInstMap.containsKey(returnType.getName())) {
                String msg = "Omitting service type {}, because its type already associated with another service.";
                logger.warn(msg, (Object)returnType.getName());
                continue;
            }
            this.serviceInstMap.put(returnType.getName(), nextAccessor);
            Service service = new Service(returnType);
            for (Class reqClass : service.getRequestClasses()) {
                if (this.serviceMap.containsKey(reqClass.getName())) {
                    String msg = "Omitting method with parameter type {} in service interface {} because its ";
                    msg = msg + "type already associated with another service.";
                    logger.warn(msg, (Object)reqClass.getName(), (Object)returnType.getName());
                    continue;
                }
                this.serviceMap.put(reqClass.getName(), service);
            }
        }
    }
}

