/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import iso.std.iso_iec._24727.tech.schema.InputAPDUInfoType;
import iso.std.iso_iec._24727.tech.schema.PasswordAttributesType;
import iso.std.iso_iec._24727.tech.schema.PasswordTypeType;
import iso.std.iso_iec._24727.tech.schema.Transmit;
import java.io.ByteArrayOutputStream;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.UtilException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PINUtils {
    private static final Logger logger = LoggerFactory.getLogger(PINUtils.class);

    public static Transmit buildVerifyTransmit(String rawPIN, PasswordAttributesType attributes, byte[] template, byte[] slotHandle) throws UtilException {
        byte[] pin = PINUtils.encodePin(rawPIN, attributes);
        byte[] pinCmd = ByteUtils.concatenate(template, (byte)pin.length);
        pinCmd = ByteUtils.concatenate(pinCmd, pin);
        Transmit transmit = new Transmit();
        transmit.setSlotHandle(slotHandle);
        InputAPDUInfoType pinApdu = new InputAPDUInfoType();
        pinApdu.setInputAPDU(pinCmd);
        transmit.getInputAPDUInfo().add(pinApdu);
        return transmit;
    }

    public static byte[] encodePin(String rawPin, PasswordAttributesType attributes) throws UtilException {
        int maxLen;
        byte[] mask = PINUtils.createPinMask(attributes);
        PasswordTypeType pwdType = attributes.getPwdType();
        int startByte = 0;
        boolean nibbleHandling = pwdType == PasswordTypeType.BCD || pwdType == PasswordTypeType.ISO_9564_1;
        int storedLen = attributes.getStoredLength().intValue();
        if (nibbleHandling) {
            storedLen *= 2;
            if (pwdType == PasswordTypeType.ISO_9564_1) {
                storedLen -= 2;
            }
        }
        int minLen = attributes.getMinLength().intValue();
        int n = maxLen = attributes.getMaxLength() == null ? storedLen : attributes.getMaxLength().intValue();
        if (minLen > rawPin.length() || rawPin.length() > maxLen) {
            UtilException ex = new UtilException("Supplied PIN has wrong length: minLen(" + minLen + ") <= PIN(" + rawPin.length() + ") <= maxLen(" + maxLen + ")");
            logger.error(ex.getMessage(), ex);
        }
        if (pwdType == PasswordTypeType.ISO_9564_1) {
            byte pinLen = (byte)rawPin.length();
            mask[0] = (byte)(mask[0] & 0xF0 | pinLen & 0xF);
            ++startByte;
        }
        int j = 0;
        block5: for (int i = startByte; i < mask.length && j < rawPin.length(); ++i) {
            int correction = 0;
            switch (pwdType) {
                case ASCII_NUMERIC: {
                    correction = 48;
                    mask[i] = (byte)(PINUtils.getByte(rawPin.charAt(j)) + correction);
                    ++j;
                    continue block5;
                }
                case HALF_NIBBLE_BCD: {
                    mask[i] = (byte)(0xF0 | PINUtils.getByte(rawPin.charAt(j)) + correction);
                    ++j;
                    continue block5;
                }
                case ISO_9564_1: 
                case BCD: {
                    byte high = (byte)(PINUtils.getByte(rawPin.charAt(j)) << 4 & 0xF0);
                    byte low = (byte)(0xF & mask[i]);
                    if (++j < rawPin.length()) {
                        low = PINUtils.getByte(rawPin.charAt(j));
                        ++j;
                    }
                    mask[i] = (byte)(high | low);
                    continue block5;
                }
                default: {
                    UtilException ex = new UtilException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#unknownPINFormat", "UTF-8 PINs are not supported.");
                    logger.error(ex.getMessage(), ex);
                    throw ex;
                }
            }
        }
        return mask;
    }

    public static byte[] createPinMask(PasswordAttributesType attributes) throws UtilException {
        int padChar;
        int minLen;
        PasswordTypeType pwdType = attributes.getPwdType();
        boolean nibbleHandling = pwdType == PasswordTypeType.BCD || pwdType == PasswordTypeType.ISO_9564_1;
        boolean needsPadding = attributes.getPwdFlags().contains("needs-padding");
        int storedLen = attributes.getStoredLength().intValue();
        if (nibbleHandling) {
            storedLen *= 2;
            if (pwdType == PasswordTypeType.ISO_9564_1) {
                storedLen -= 2;
            }
        }
        if ((minLen = attributes.getMinLength().intValue()) < storedLen) {
            needsPadding = true;
        } else if (nibbleHandling && storedLen % 2 != 0) {
            needsPadding = true;
        }
        if (pwdType == PasswordTypeType.ISO_9564_1) {
            needsPadding = true;
            padChar = -1;
        } else if (needsPadding) {
            byte[] padChars = attributes.getPadChar();
            if (padChars == null || padChars.length == 0) {
                UtilException ex = new UtilException("Unsupported combination of PIN parameters concerning padding.");
                logger.error(ex.getMessage(), ex);
                throw ex;
            }
            padChar = padChars[0];
        } else {
            padChar = -1;
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        switch (pwdType) {
            case ISO_9564_1: {
                o.write(32);
            }
            case BCD: {
                int i;
                for (i = 0; i < storedLen; i += 2) {
                    o.write(padChar);
                }
                break;
            }
            case ASCII_NUMERIC: 
            case HALF_NIBBLE_BCD: {
                int i;
                for (i = 0; i < storedLen; ++i) {
                    o.write(padChar);
                }
                break;
            }
            default: {
                UtilException ex = new UtilException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#unknownPINFormat", "Pin with format '" + pwdType.name() + "' not supported.");
                logger.error(ex.getMessage(), ex);
                throw ex;
            }
        }
        byte[] result = o.toByteArray();
        return result;
    }

    private static byte getByte(char c) throws UtilException {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        UtilException ex = new UtilException("Entered PIN contains invalid characters.");
        logger.error(ex.getMessage(), ex);
        throw ex;
    }
}

