/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.util;

public abstract class Pack {
    public static int bigEndianToInt(byte[] bs, int off) {
        int n = bs[off] << 24;
        n |= (bs[++off] & 0xFF) << 16;
        n |= (bs[++off] & 0xFF) << 8;
        return n |= bs[++off] & 0xFF;
    }

    public static void bigEndianToInt(byte[] bs, int off, int[] ns) {
        for (int i = 0; i < ns.length; ++i) {
            ns[i] = Pack.bigEndianToInt(bs, off);
            off += 4;
        }
    }

    public static void intToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    public static void intToBigEndian(int[] ns, byte[] bs, int off) {
        for (int i = 0; i < ns.length; ++i) {
            Pack.intToBigEndian(ns[i], bs, off);
            off += 4;
        }
    }

    public static long bigEndianToLong(byte[] bs, int off) {
        int hi = Pack.bigEndianToInt(bs, off);
        int lo = Pack.bigEndianToInt(bs, off + 4);
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static void longToBigEndian(long n, byte[] bs, int off) {
        Pack.intToBigEndian((int)(n >>> 32), bs, off);
        Pack.intToBigEndian((int)(n & 0xFFFFFFFFL), bs, off + 4);
    }

    public static int littleEndianToInt(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        n |= (bs[++off] & 0xFF) << 16;
        return n |= bs[++off] << 24;
    }

    public static void littleEndianToInt(byte[] bs, int off, int[] ns) {
        for (int i = 0; i < ns.length; ++i) {
            ns[i] = Pack.littleEndianToInt(bs, off);
            off += 4;
        }
    }

    public static void intToLittleEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 24);
    }

    public static void intToLittleEndian(int[] ns, byte[] bs, int off) {
        for (int i = 0; i < ns.length; ++i) {
            Pack.intToLittleEndian(ns[i], bs, off);
            off += 4;
        }
    }

    public static long littleEndianToLong(byte[] bs, int off) {
        int lo = Pack.littleEndianToInt(bs, off);
        int hi = Pack.littleEndianToInt(bs, off + 4);
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static void longToLittleEndian(long n, byte[] bs, int off) {
        Pack.intToLittleEndian((int)(n & 0xFFFFFFFFL), bs, off);
        Pack.intToLittleEndian((int)(n >>> 32), bs, off + 4);
    }
}

