/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.anytype;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import java.util.ArrayList;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.StringUtils;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificate;
import org.openecard.sal.protocol.eac.anytype.EAC1OutputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class EAC1InputType {
    private static final Logger logger = LoggerFactory.getLogger(EAC1InputType.class);
    public static final String CERTIFICATE = "Certificate";
    public static final String CERTIFICATE_DESCRIPTION = "CertificateDescription";
    public static final String REQUIRED_CHAT = "RequiredCHAT";
    public static final String OPTIONAL_CHAT = "OptionalCHAT";
    public static final String AUTHENTICATED_AUXILIARY_DATA = "AuthenticatedAuxiliaryData";
    private final AuthDataMap authMap;
    private ArrayList<CardVerifiableCertificate> certificates;
    private byte[] certificateDescription;
    private byte[] requiredCHAT;
    private byte[] optionalCHAT;
    private byte[] authenticatedAuxiliaryData;

    public EAC1InputType(DIDAuthenticationDataType baseType) throws Exception {
        this.authMap = new AuthDataMap(baseType);
        this.certificateDescription = this.authMap.getContentAsBytes(CERTIFICATE_DESCRIPTION);
        this.requiredCHAT = this.authMap.getContentAsBytes(REQUIRED_CHAT);
        this.optionalCHAT = this.authMap.getContentAsBytes(OPTIONAL_CHAT);
        this.requiredCHAT = EAC1InputType.fixChatValue(this.requiredCHAT);
        this.optionalCHAT = EAC1InputType.fixChatValue(this.optionalCHAT);
        this.authenticatedAuxiliaryData = this.authMap.getContentAsBytes(AUTHENTICATED_AUXILIARY_DATA);
        this.certificates = new ArrayList();
        for (Element element : baseType.getAny()) {
            if (!element.getLocalName().equals(CERTIFICATE)) continue;
            byte[] value = StringUtils.toByteArray(element.getTextContent());
            CardVerifiableCertificate cvc = new CardVerifiableCertificate(value);
            this.certificates.add(cvc);
        }
    }

    public ArrayList<CardVerifiableCertificate> getCertificates() {
        return this.certificates;
    }

    public byte[] getCertificateDescription() {
        return this.certificateDescription;
    }

    public byte[] getRequiredCHAT() {
        return this.requiredCHAT;
    }

    public byte[] getOptionalCHAT() {
        return this.optionalCHAT;
    }

    public byte[] getAuthenticatedAuxiliaryData() {
        return this.authenticatedAuxiliaryData;
    }

    public EAC1OutputType getOutputType() {
        return new EAC1OutputType(this.authMap);
    }

    private static byte[] fixChatValue(byte[] chat) {
        if (chat.length == 5) {
            logger.warn("Correcting invalid CHAT value '{}'.", (Object)ByteUtils.toHexString(chat));
            String asn1Prefix = "7F4C12060904007F0007030102025305";
            byte[] prefixBytes = StringUtils.toByteArray(asn1Prefix);
            byte[] result = ByteUtils.concatenate(prefixBytes, chat);
            return result;
        }
        return chat;
    }
}

