/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private int limit;

    public LimitedInputStream(InputStream inputStream) {
        this(inputStream, 0x100000);
    }

    public LimitedInputStream(InputStream inputStream, int limit) {
        super(inputStream);
        this.limit = limit;
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            --this.limit;
            this.checkLimit();
        }
        return res;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res != -1) {
            this.limit -= len;
            this.checkLimit();
        }
        return res;
    }

    private void checkLimit() throws IOException {
        if (this.limit < 1) {
            throw new IOException("Input streams limit is reached.");
        }
    }
}

