/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu.exception;

import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.ECardException;
import org.openecard.common.apdu.common.CardResponseAPDU;

public final class APDUException
extends ECardException {
    private static final long serialVersionUID = 1L;
    private TransmitResponse transmitResponse;
    private CardResponseAPDU responseAPDU;

    public APDUException(String msg) {
        APDUException.makeException(this, msg);
    }

    public APDUException(String minor, String msg) {
        APDUException.makeException(this, minor, msg);
    }

    public APDUException(Result r) {
        APDUException.makeException(this, r);
    }

    public APDUException(Throwable cause) {
        APDUException.makeException(this, cause);
    }

    public APDUException(Throwable cause, TransmitResponse tr) {
        this(cause);
        this.transmitResponse = tr;
        this.responseAPDU = new CardResponseAPDU(tr);
    }

    public TransmitResponse getTransmitResponse() {
        return this.transmitResponse;
    }

    public CardResponseAPDU getResponseAPDU() {
        return this.responseAPDU;
    }
}

