/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.modes.gcm;

import java.util.ArrayList;
import org.openecard.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import org.openecard.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.openecard.bouncycastle.util.Arrays;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private ArrayList lookupPowX2;

    @Override
    public void init(byte[] x) {
        if (this.lookupPowX2 != null && Arrays.areEqual(x, (byte[])this.lookupPowX2.get(0))) {
            return;
        }
        this.lookupPowX2 = new ArrayList(8);
        this.lookupPowX2.add(Arrays.clone(x));
    }

    @Override
    public void exponentiateX(long pow, byte[] output) {
        byte[] y = GCMUtil.oneAsBytes();
        if (pow > 0L) {
            int bit = 0;
            this.ensureAvailable(63 - Long.numberOfLeadingZeros(pow));
            do {
                if ((pow & 1L) != 0L) {
                    GCMUtil.multiply(y, (byte[])this.lookupPowX2.get(bit));
                }
                ++bit;
            } while ((pow >>>= 1) > 0L);
        }
        System.arraycopy(y, 0, output, 0, 16);
    }

    private void ensureAvailable(int bit) {
        int count = this.lookupPowX2.size();
        if (count <= bit) {
            byte[] tmp = (byte[])this.lookupPowX2.get(count - 1);
            do {
                tmp = Arrays.clone(tmp);
                GCMUtil.multiply(tmp, tmp);
                this.lookupPowX2.add(tmp);
            } while (++count <= bit);
        }
    }
}

