/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.scio.osx;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PlatformPCSC {
    private static final String PCSC_JNI_LIBRARY_PATH = "/osx-pcsc-jni/";
    private static final String PCSC_JNI_LIBRARY_NAME = "libosxj2pcsc.dylib";
    private static final String PCSC_FRAMEWORK = "/System/Library/Frameworks/PCSC.framework/Versions/Current/PCSC";
    public static final int SCARD_PROTOCOL_T0 = 1;
    public static final int SCARD_PROTOCOL_T1 = 2;
    public static final int SCARD_PROTOCOL_RAW = 4;
    public static final int SCARD_UNKNOWN = 1;
    public static final int SCARD_ABSENT = 2;
    public static final int SCARD_PRESENT = 4;
    public static final int SCARD_SWALLOWED = 8;
    public static final int SCARD_POWERED = 16;
    public static final int SCARD_NEGOTIABLE = 32;
    public static final int SCARD_SPECIFIC = 64;
    public static final Exception INIT_EXCEPTION = AccessController.doPrivileged(new PrivilegedAction<Exception>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exception run() {
            try {
                String[] parts = PlatformPCSC.PCSC_JNI_LIBRARY_NAME.split("\\.");
                File tempFile = File.createTempFile(parts[0], parts[1]);
                tempFile.deleteOnExit();
                InputStream is = PlatformPCSC.class.getResourceAsStream(PlatformPCSC.PCSC_JNI_LIBRARY_PATH + PlatformPCSC.getLibrary());
                if (is == null) {
                    return new FileNotFoundException(PlatformPCSC.getLibrary() + " not found.");
                }
                FileOutputStream os = new FileOutputStream(tempFile);
                try {
                    int readBytes;
                    byte[] buffer = new byte[1024];
                    while ((readBytes = is.read(buffer)) != -1) {
                        ((OutputStream)os).write(buffer, 0, readBytes);
                    }
                    System.load(tempFile.getAbsolutePath());
                    PlatformPCSC.initialize(PlatformPCSC.PCSC_FRAMEWORK);
                }
                finally {
                    ((OutputStream)os).close();
                    is.close();
                }
                return null;
            }
            catch (Exception e) {
                return e;
            }
        }
    });

    private static String getLibrary() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.6")) {
            return "jre6.libosxj2pcsc.dylib";
        }
        if (javaVersion.startsWith("1.7")) {
            return "jre7.libosxj2pcsc.dylib";
        }
        return null;
    }

    private static native void initialize(String var0);
}

