/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.openecard.addon.AddonManager;
import org.openecard.common.I18n;
import org.openecard.gui.graphics.GraphicsUtil;
import org.openecard.gui.graphics.OecLogoBgWhite;
import org.openecard.recognition.CardRecognition;
import org.openecard.richclient.RichClient;
import org.openecard.richclient.gui.GuiUtils;
import org.openecard.richclient.gui.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppTray {
    private static final Logger logger = LoggerFactory.getLogger(AppTray.class);
    private static final String ICON_LOADER = "loader";
    private static final String ICON_LOGO = "logo";
    private final I18n lang = I18n.getTranslation("richclient");
    private SystemTray tray;
    private TrayIcon trayIcon;
    private Status status;
    private JFrame frame;
    private JLabel label;
    private RichClient client;
    private Boolean isLinux = null;
    private Boolean isKde = null;
    private boolean trayAvailable;

    public AppTray(RichClient client) {
        this.client = client;
    }

    public void beginSetup() {
        if (SystemTray.isSupported()) {
            this.setupTrayIcon();
        } else {
            this.setupFrame();
        }
    }

    public void endSetup(CardRecognition rec, AddonManager manager) {
        if (this.trayAvailable) {
            this.trayIcon.setImage(this.getTrayIconImage(ICON_LOGO));
            this.trayIcon.setToolTip(this.lang.translationForKey("tray.title", new Object[0]));
        } else {
            this.label.setIcon(new ImageIcon(GraphicsUtil.createImage(OecLogoBgWhite.class, 256, 256)));
        }
        this.status = new Status(this, rec, manager);
    }

    public Status status() {
        return this.status;
    }

    public void shutdown() {
        if (this.trayAvailable) {
            this.trayIcon.displayMessage("Open eCard App", this.lang.translationForKey("tray.message.shutdown", new Object[0]), TrayIcon.MessageType.INFO);
            this.client.teardown();
            this.tray.remove(this.trayIcon);
        } else {
            this.client.teardown();
        }
        System.exit(0);
    }

    private void setupTrayIcon() {
        this.trayAvailable = true;
        this.tray = SystemTray.getSystemTray();
        this.trayIcon = new TrayIcon(this.getTrayIconImage(ICON_LOADER), this.lang.translationForKey("tray.message.loading", new Object[0]), null);
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AppTray.this.status != null) {
                    AppTray.this.status.showInfo(new Point(e.getX(), e.getY()));
                }
            }
        });
        try {
            this.tray.add(this.trayIcon);
        }
        catch (AWTException ex) {
            logger.error("TrayIcon could not be added to the system tray.", ex);
            this.tray = null;
            this.trayIcon = null;
            this.setupFrame();
        }
    }

    private Image getTrayIconImage(String name) {
        Dimension dim = this.tray.getTrayIconSize();
        if (this.isLinux()) {
            if (this.isKde()) {
                return this.getImageKde(name, dim);
            }
            return this.getImageLinux(name, dim);
        }
        if (this.isMacOSX()) {
            return this.getImageMacOSX(name, dim);
        }
        return this.getImageDefault(name, dim);
    }

    private Image getImageKde(String name, Dimension dim) {
        if (name.equals(ICON_LOADER)) {
            switch (dim.width) {
                case 24: {
                    return GuiUtils.getImage("loader_icon_linux_kde_24.gif");
                }
            }
            return GuiUtils.getImage("loader_icon_linux_default_256.gif");
        }
        return GraphicsUtil.createImage(OecLogoBgWhite.class, dim.width - 2, dim.height - 2, dim.width, dim.height, 0, 0);
    }

    private Image getImageLinux(String name, Dimension dim) {
        if (name.equals(ICON_LOADER)) {
            return GuiUtils.getImage("loader_icon_linux_default_256.gif");
        }
        return GraphicsUtil.createImage(OecLogoBgWhite.class, dim.width, dim.height);
    }

    private Image getImageMacOSX(String name, Dimension dim) {
        return GraphicsUtil.createImage(OecLogoBgWhite.class, dim.width - 2, dim.height - 2, dim.width, dim.height, 1, 1);
    }

    private Image getImageDefault(String name, Dimension dim) {
        if (name.equals(ICON_LOADER)) {
            return GuiUtils.getImage("loader_icon_default_256.gif");
        }
        return GraphicsUtil.createImage(OecLogoBgWhite.class, dim.width, dim.height);
    }

    private boolean isMacOSX() {
        return System.getProperty("os.name").contains("OS X");
    }

    private boolean isLinux() {
        if (this.isLinux == null) {
            String os = System.getProperty("os.name").toLowerCase();
            this.isLinux = os.indexOf("nux") >= 0;
        }
        return this.isLinux;
    }

    private boolean isKde() {
        if (this.isKde == null) {
            String kdeSession = System.getenv("KDE_FULL_SESSION");
            this.isKde = kdeSession != null && !kdeSession.isEmpty() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.isKde;
    }

    private void setupFrame() {
        this.trayAvailable = false;
        this.frame = new JFrame(this.lang.translationForKey("tray.title", new Object[0]));
        this.frame.setDefaultCloseOperation(3);
        this.frame.setIconImage(GraphicsUtil.createImage(OecLogoBgWhite.class, 256, 256));
        this.label = new JLabel(GuiUtils.getImageIcon("loader_icon_default_64.gif"));
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AppTray.this.status.showInfo(e.getLocationOnScreen());
            }
        });
        ImageIcon logo = new ImageIcon(GraphicsUtil.createImage(OecLogoBgWhite.class, 256, 256));
        Container c = this.frame.getContentPane();
        c.setPreferredSize(new Dimension(logo.getIconWidth(), logo.getIconHeight()));
        c.setBackground(Color.white);
        c.add(this.label);
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }
}

